<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scroll_categories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade'); // Null for global scrolls
            $table->string('title');
            $table->string('icon')->nullable(); // Icon name or emoji
            $table->string('color')->default('#d4a65a'); // Gold color by default
            $table->text('description')->nullable();
            $table->json('rewards')->nullable(); // Optional rewards info
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scroll_categories');
    }
};
