<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('characters', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->string('image_normal')->nullable();
            $table->string('image_win')->nullable();
            $table->string('image_loss')->nullable();
            $table->string('sprite_source')->nullable();
            
            // Unlock conditions
            $table->integer('unlock_level')->nullable()->comment('Level required to unlock (null = shop only)');
            $table->integer('cost_gold')->nullable()->comment('Gold cost (null = not purchasable)');
            $table->integer('cost_premium')->nullable()->comment('Premium coins cost (null = not purchasable)');
            $table->boolean('is_vip_only')->default(false);
            
            // Character stats bonuses
            $table->integer('hp_bonus')->default(0);
            $table->integer('attack_bonus')->default(0);
            $table->integer('defense_bonus')->default(0);
            $table->integer('stamina_bonus')->default(0);
            
            // Display
            $table->string('rarity')->default('common')->comment('common, rare, epic, legendary');
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('characters');
    }
};
