<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'character_id')) {
                $table->foreignId('character_id')->nullable()->after('last_hp_regen_at')->constrained('characters')->onDelete('set null');
            }
        });
        
        // Create user_characters pivot table for owned characters
        Schema::create('user_characters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('character_id')->constrained()->onDelete('cascade');
            $table->timestamp('unlocked_at')->nullable();
            $table->string('unlock_method')->nullable()->comment('level_up, purchase_gold, purchase_premium');
            $table->timestamps();
            
            $table->unique(['user_id', 'character_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'character_id')) {
                $table->dropForeign(['character_id']);
                $table->dropColumn('character_id');
            }
        });
        
        Schema::dropIfExists('user_characters');
    }
};
