<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            if (!Schema::hasColumn('characters', 'video_url')) {
                $table->string('video_url')->nullable()->after('sprite_source')->comment('Character video URL');
            }
            if (!Schema::hasColumn('characters', 'video_win')) {
                $table->string('video_win')->nullable()->after('video_url')->comment('Character win video URL');
            }
            if (!Schema::hasColumn('characters', 'video_loss')) {
                $table->string('video_loss')->nullable()->after('video_win')->comment('Character loss video URL');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            if (Schema::hasColumn('characters', 'video_url')) {
                $table->dropColumn('video_url');
            }
            if (Schema::hasColumn('characters', 'video_win')) {
                $table->dropColumn('video_win');
            }
            if (Schema::hasColumn('characters', 'video_loss')) {
                $table->dropColumn('video_loss');
            }
        });
    }
};
