<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            // Add new image fields for idle, lost, and winning states (static and animated)
            if (!Schema::hasColumn('characters', 'image_idle')) {
                $table->string('image_idle')->nullable()->after('image_normal')->comment('Idle static image');
            }
            if (!Schema::hasColumn('characters', 'image_idle_animation')) {
                $table->string('image_idle_animation')->nullable()->after('image_idle')->comment('Idle animation (GIF/video)');
            }
            if (!Schema::hasColumn('characters', 'image_lost')) {
                $table->string('image_lost')->nullable()->after('image_loss')->comment('Lost static image');
            }
            if (!Schema::hasColumn('characters', 'image_lost_animation')) {
                $table->string('image_lost_animation')->nullable()->after('image_lost')->comment('Lost animation (GIF/video)');
            }
            if (!Schema::hasColumn('characters', 'image_winning')) {
                $table->string('image_winning')->nullable()->after('image_win')->comment('Winning static image');
            }
            if (!Schema::hasColumn('characters', 'image_winning_animation')) {
                $table->string('image_winning_animation')->nullable()->after('image_winning')->comment('Winning animation (GIF/video)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            if (Schema::hasColumn('characters', 'image_idle')) {
                $table->dropColumn('image_idle');
            }
            if (Schema::hasColumn('characters', 'image_idle_animation')) {
                $table->dropColumn('image_idle_animation');
            }
            if (Schema::hasColumn('characters', 'image_lost')) {
                $table->dropColumn('image_lost');
            }
            if (Schema::hasColumn('characters', 'image_lost_animation')) {
                $table->dropColumn('image_lost_animation');
            }
            if (Schema::hasColumn('characters', 'image_winning')) {
                $table->dropColumn('image_winning');
            }
            if (Schema::hasColumn('characters', 'image_winning_animation')) {
                $table->dropColumn('image_winning_animation');
            }
        });
    }
};
