<?php

namespace Database\Seeders;

use App\Models\Achievement;
use Illuminate\Database\Seeder;

class AchievementSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $achievements = [
            // Task completion achievements
            ['name' => 'First Steps', 'description' => 'Complete your first task', 'icon' => '🎯', 'condition_type' => 'tasks_completed', 'condition_value' => 1],
            ['name' => 'Task Master', 'description' => 'Complete 10 tasks', 'icon' => '⭐', 'condition_type' => 'tasks_completed', 'condition_value' => 10],
            ['name' => 'Productivity Hero', 'description' => 'Complete 50 tasks', 'icon' => '🏆', 'condition_type' => 'tasks_completed', 'condition_value' => 50],
            ['name' => 'Legendary Worker', 'description' => 'Complete 100 tasks', 'icon' => '👑', 'condition_type' => 'tasks_completed', 'condition_value' => 100],
            
            // Daily task achievements
            ['name' => 'Daily Warrior', 'description' => 'Complete 5 daily tasks', 'icon' => '📅', 'condition_type' => 'daily_tasks_completed', 'condition_value' => 5],
            ['name' => 'Habit Builder', 'description' => 'Complete 20 daily tasks', 'icon' => '🔥', 'condition_type' => 'daily_tasks_completed', 'condition_value' => 20],
            ['name' => 'Consistency King', 'description' => 'Complete 50 daily tasks', 'icon' => '💪', 'condition_type' => 'daily_tasks_completed', 'condition_value' => 50],
            
            // Level achievements
            ['name' => 'Rising Star', 'description' => 'Reach level 5', 'icon' => '🌟', 'condition_type' => 'level_reached', 'condition_value' => 5],
            ['name' => 'Veteran', 'description' => 'Reach level 10', 'icon' => '🎖️', 'condition_type' => 'level_reached', 'condition_value' => 10],
            ['name' => 'Master', 'description' => 'Reach level 20', 'icon' => '⚔️', 'condition_type' => 'level_reached', 'condition_value' => 20],
            ['name' => 'Legend', 'description' => 'Reach level 30', 'icon' => '👑', 'condition_type' => 'level_reached', 'condition_value' => 30],
            
            // Battle achievements
            ['name' => 'First Victory', 'description' => 'Win your first battle', 'icon' => '⚔️', 'condition_type' => 'battles_won', 'condition_value' => 1],
            ['name' => 'Warrior', 'description' => 'Win 10 battles', 'icon' => '🛡️', 'condition_type' => 'battles_won', 'condition_value' => 10],
            ['name' => 'Champion', 'description' => 'Win 25 battles', 'icon' => '🏅', 'condition_type' => 'battles_won', 'condition_value' => 25],
            ['name' => 'Battle Master', 'description' => 'Win 50 battles', 'icon' => '⚡', 'condition_type' => 'battles_won', 'condition_value' => 50],
        ];

        foreach ($achievements as $achievement) {
            Achievement::create($achievement);
        }
    }
}
