<?php

namespace Database\Seeders;

use App\Models\Character;
use Illuminate\Database\Seeder;

class CharacterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Farmer Peasant - Default/Weakest Character
        Character::updateOrCreate(
            ['slug' => 'farmer-peasant'],
            [
                'name' => 'Farmer Peasant',
                'slug' => 'farmer-peasant',
                'description' => 'The weakest character in the game. A simple civilian farmer who uses only fists. Perfect for early tutorial battles and basic enemies.',
                'image_normal' => null,
                'image_idle' => null,
                'image_idle_animation' => null,
                'image_win' => null,
                'image_winning' => null,
                'image_winning_animation' => null,
                'image_loss' => null,
                'image_lost' => null,
                'image_lost_animation' => null,
                'sprite_source' => null,
                'video_url' => null,
                'video_win' => null,
                'video_loss' => null,
                
                // Unlock conditions - Available from start (level 1)
                'unlock_level' => 1,
                'cost_gold' => 0, // Free
                'cost_premium' => null,
                'is_vip_only' => false,
                
                // Character stats bonuses
                // Base user stats: hp: 120, atk: 12, def: 5
                // Target stats: hp: 30, atk: 4, def: 2
                // Bonuses needed: hp: -90, atk: -8, def: -3
                'hp_bonus' => -90, // Results in 30 HP (120 - 90 = 30)
                'attack_bonus' => -8, // Results in 4 attack (12 - 8 = 4)
                'defense_bonus' => -3, // Results in 2 defense (5 - 3 = 2)
                'stamina_bonus' => 0, // No stamina change
                
                // Display
                'rarity' => 'common',
                'sort_order' => 1, // First in list (default character)
                'is_active' => true,
            ]
        );
    }
}

