<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\CoinPack;

class CoinPackSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $packs = [
            [
                'name' => 'Small Pack',
                'coins_amount' => 100,
                'bonus_coins' => 0,
                'price_usd' => 1.99,
                'price_egp' => null,
                'is_active' => true,
            ],
            [
                'name' => 'Medium Pack',
                'coins_amount' => 550,
                'bonus_coins' => 50,
                'price_usd' => 8.99,
                'price_egp' => null,
                'is_active' => true,
            ],
            [
                'name' => 'Large Pack',
                'coins_amount' => 1200,
                'bonus_coins' => 200,
                'price_usd' => 14.99,
                'price_egp' => null,
                'is_active' => true,
            ],
        ];

        foreach ($packs as $pack) {
            CoinPack::create($pack);
        }
    }
}
