<?php

namespace Database\Seeders;

use App\Models\Enemy;
use App\Models\Item;
use App\Services\AssetService;
use Illuminate\Database\Seeder;

class EnemySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $assetService = new AssetService();
        
        $enemies = [
            ['name' => 'Goblin', 'level' => 1, 'attack' => 5, 'defense' => 2, 'hp' => 20, 'xp_reward' => 10, 'gold_reward' => 15],
            ['name' => 'Orc', 'level' => 2, 'attack' => 12, 'defense' => 5, 'hp' => 40, 'xp_reward' => 25, 'gold_reward' => 30],
            ['name' => 'Wolf', 'level' => 3, 'attack' => 15, 'defense' => 8, 'hp' => 50, 'xp_reward' => 35, 'gold_reward' => 40],
            ['name' => 'Skeleton Warrior', 'level' => 4, 'attack' => 20, 'defense' => 12, 'hp' => 60, 'xp_reward' => 50, 'gold_reward' => 60],
            ['name' => 'Dark Mage', 'level' => 5, 'attack' => 25, 'defense' => 15, 'hp' => 70, 'xp_reward' => 70, 'gold_reward' => 80],
            ['name' => 'Troll', 'level' => 6, 'attack' => 30, 'defense' => 20, 'hp' => 100, 'xp_reward' => 90, 'gold_reward' => 100],
            ['name' => 'Shadow Demon', 'level' => 7, 'attack' => 35, 'defense' => 25, 'hp' => 120, 'xp_reward' => 110, 'gold_reward' => 130],
            ['name' => 'Ice Elemental', 'level' => 8, 'attack' => 40, 'defense' => 30, 'hp' => 140, 'xp_reward' => 140, 'gold_reward' => 160],
            ['name' => 'Fire Dragon', 'level' => 9, 'attack' => 50, 'defense' => 35, 'hp' => 180, 'xp_reward' => 180, 'gold_reward' => 200],
            ['name' => 'Ancient Guardian', 'level' => 10, 'attack' => 60, 'defense' => 45, 'hp' => 200, 'xp_reward' => 220, 'gold_reward' => 250],
            ['name' => 'Death Knight', 'level' => 12, 'attack' => 75, 'defense' => 55, 'hp' => 250, 'xp_reward' => 300, 'gold_reward' => 350],
            ['name' => 'Demon Lord', 'level' => 15, 'attack' => 100, 'defense' => 70, 'hp' => 350, 'xp_reward' => 500, 'gold_reward' => 600],
        ];

        // Get some items for drops
        $items = Item::all();
        $itemCount = $items->count();

        foreach ($enemies as $index => $enemyData) {
            // 30% chance to have a drop item
            $dropItemId = null;
            if (rand(1, 100) <= 30 && $itemCount > 0) {
                $dropItemId = $items->random()->id;
            }

            Enemy::create([
                ...$enemyData,
                'image_url' => $assetService->generateEnemyImage(),
                'drop_item_id' => $dropItemId,
            ]);
        }
    }
}
