<?php

namespace Database\Seeders;

use App\Models\Item;
use App\Services\AssetService;
use Illuminate\Database\Seeder;

class ItemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $assetService = new AssetService();
        
        $items = [
            // Weapons
            ['name' => 'Wooden Sword', 'type' => 'weapon', 'attack' => 5, 'defense' => 0, 'magic' => 0, 'stamina' => 0, 'cost' => 50, 'required_level' => 1],
            ['name' => 'Iron Sword', 'type' => 'weapon', 'attack' => 15, 'defense' => 0, 'magic' => 0, 'stamina' => 0, 'cost' => 200, 'required_level' => 5],
            ['name' => 'Steel Blade', 'type' => 'weapon', 'attack' => 30, 'defense' => 5, 'magic' => 0, 'stamina' => 0, 'cost' => 500, 'required_level' => 10],
            ['name' => 'Magic Staff', 'type' => 'weapon', 'attack' => 10, 'defense' => 0, 'magic' => 25, 'stamina' => 0, 'cost' => 400, 'required_level' => 8],
            ['name' => 'Dragon Sword', 'type' => 'weapon', 'attack' => 50, 'defense' => 10, 'magic' => 15, 'stamina' => 0, 'cost' => 1500, 'required_level' => 20],
            
            // Armor
            ['name' => 'Leather Armor', 'type' => 'armor', 'attack' => 0, 'defense' => 10, 'magic' => 0, 'stamina' => 20, 'cost' => 100, 'required_level' => 2],
            ['name' => 'Chainmail', 'type' => 'armor', 'attack' => 0, 'defense' => 25, 'magic' => 0, 'stamina' => 40, 'cost' => 300, 'required_level' => 6],
            ['name' => 'Plate Armor', 'type' => 'armor', 'attack' => 0, 'defense' => 45, 'magic' => 0, 'stamina' => 60, 'cost' => 700, 'required_level' => 12],
            ['name' => 'Mage Robe', 'type' => 'armor', 'attack' => 0, 'defense' => 15, 'magic' => 30, 'stamina' => 30, 'cost' => 600, 'required_level' => 10],
            ['name' => 'Dragon Scale', 'type' => 'armor', 'attack' => 0, 'defense' => 70, 'magic' => 20, 'stamina' => 80, 'cost' => 2000, 'required_level' => 25],
            
            // Potions
            ['name' => 'Health Potion', 'type' => 'potion', 'attack' => 0, 'defense' => 0, 'magic' => 0, 'stamina' => 50, 'cost' => 30, 'required_level' => 1],
            ['name' => 'Mana Potion', 'type' => 'potion', 'attack' => 0, 'defense' => 0, 'magic' => 20, 'stamina' => 0, 'cost' => 25, 'required_level' => 1],
            ['name' => 'Strength Elixir', 'type' => 'potion', 'attack' => 10, 'defense' => 0, 'magic' => 0, 'stamina' => 0, 'cost' => 80, 'required_level' => 3],
            ['name' => 'Greater Health Potion', 'type' => 'potion', 'attack' => 0, 'defense' => 0, 'magic' => 0, 'stamina' => 100, 'cost' => 100, 'required_level' => 5],
            
            // Tools
            ['name' => 'Lucky Charm', 'type' => 'tool', 'attack' => 5, 'defense' => 5, 'magic' => 5, 'stamina' => 10, 'cost' => 150, 'required_level' => 4],
            ['name' => 'Warrior Badge', 'type' => 'tool', 'attack' => 15, 'defense' => 15, 'magic' => 0, 'stamina' => 20, 'cost' => 350, 'required_level' => 7],
            ['name' => 'Wisdom Amulet', 'type' => 'tool', 'attack' => 0, 'defense' => 10, 'magic' => 20, 'stamina' => 15, 'cost' => 400, 'required_level' => 9],
            ['name' => 'Hero\'s Medallion', 'type' => 'tool', 'attack' => 20, 'defense' => 20, 'magic' => 20, 'stamina' => 30, 'cost' => 1000, 'required_level' => 15],
        ];

        foreach ($items as $itemData) {
            Item::create([
                ...$itemData,
                'image_url' => $assetService->generateItemImage(),
            ]);
        }
    }
}
