<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Level;

class LevelsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $levels = [];
        $cumulativeHpBonus = 0;
        $cumulativeAttackBonus = 0;
        $cumulativeDefenseBonus = 0;
        $cumulativeStaminaBonus = 0;

        // Title milestones
        $titles = [
            1 => 'Novice',
            10 => 'Warrior',
            25 => 'Veteran',
            50 => 'Champion',
            75 => 'Master',
            100 => 'Legend',
            150 => 'Mythic',
            200 => 'Divine',
        ];

        for ($level = 1; $level <= 200; $level++) {
            // Calculate XP required for this level
            $xpRequired = floor(100 * $level * pow(1.12, $level - 1));

            // Calculate stat bonuses (cumulative)
            $hpBonus = 5 + floor($level * 0.5);
            $attackBonus = 1 + floor($level * 0.2);
            $defenseBonus = 1 + floor($level * 0.15);
            $staminaBonus = 1;

            $cumulativeHpBonus += $hpBonus;
            $cumulativeAttackBonus += $attackBonus;
            $cumulativeDefenseBonus += $defenseBonus;
            $cumulativeStaminaBonus += $staminaBonus;

            $levels[] = [
                'level' => $level,
                'xp_required' => $xpRequired,
                'hp_bonus' => $cumulativeHpBonus,
                'attack_bonus' => $cumulativeAttackBonus,
                'defense_bonus' => $cumulativeDefenseBonus,
                'stamina_bonus' => $cumulativeStaminaBonus,
                'title' => $titles[$level] ?? null,
                'created_at' => now(),
                'updated_at' => now(),
            ];

            // Insert in chunks of 50 for performance
            if (count($levels) >= 50) {
                Level::insert($levels);
                $levels = [];
            }
        }

        // Insert remaining levels
        if (!empty($levels)) {
            Level::insert($levels);
        }
    }
}
