<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ScrollCategory;

class ScrollCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $scrolls = [
            [
                'title' => 'Daily Scroll',
                'icon' => '📜',
                'color' => '#d4a65a',
                'description' => 'Quests that refresh each day. Complete them to earn daily rewards!',
                'sort_order' => 1,
            ],
            [
                'title' => 'Weekly Scroll',
                'icon' => '🗺️',
                'color' => '#0fb9b1',
                'description' => 'Longer quests that reset weekly. Greater challenges, greater rewards!',
                'sort_order' => 2,
            ],
            [
                'title' => 'Story Scroll',
                'icon' => '📖',
                'color' => '#b33939',
                'description' => 'Main storyline quests. Follow the epic tale of Ra\'s blessing!',
                'sort_order' => 3,
            ],
            [
                'title' => 'Side Quests Scroll',
                'icon' => '⚔️',
                'color' => '#f5e6b2',
                'description' => 'Optional adventures and side stories. Explore at your own pace!',
                'sort_order' => 4,
            ],
            [
                'title' => 'Event Scroll',
                'icon' => '🎉',
                'color' => '#d4af37',
                'description' => 'Limited-time event quests. Don\'t miss out on special rewards!',
                'sort_order' => 5,
            ],
            [
                'title' => 'Skill Training Scroll',
                'icon' => '🧘',
                'color' => '#0fb9b1',
                'description' => 'Focus on improving your skills and abilities. Practice makes perfect!',
                'sort_order' => 6,
            ],
        ];

        foreach ($scrolls as $scroll) {
            ScrollCategory::updateOrCreate(
                ['title' => $scroll['title']],
                $scroll
            );
        }
    }
}
