# Character Animation Assets

This directory contains PNG sequence animations for characters.

## Folder Structure

Each character has its own folder named after the character's slug (e.g., `farmer-peasant`).

### Base Structure (No Direction)
```
assets/characters/{character-slug}/
├── idle/
│   ├── 01.png
│   ├── 02.png
│   └── ...
├── fight/          (for 'attack' state)
│   ├── 01.png
│   ├── 02.png
│   └── ...
├── magic/
│   ├── 01.png
│   └── ...
├── win/
│   ├── 01.png
│   └── ...
└── lose/
    ├── 01.png
    └── ...
```

### With Direction Support (Recommended)
```
assets/characters/{character-slug}/
├── idle/
│   ├── right/      (facing right, towards mob)
│   │   ├── 01.png
│   │   ├── 02.png
│   │   └── ...
│   └── left/        (facing left, away from mob)
│       ├── 01.png
│       └── ...
├── fight/
│   ├── right/
│   │   ├── 01.png
│   │   └── ...
│   └── left/
│       ├── 01.png
│       └── ...
└── ...
```

## Animation States

- **idle**: Character standing still (looping)
- **attack**: Character attacking (uses `fight/` folder, non-looping, auto-returns to idle)
- **magic**: Character casting magic (looping, auto-returns to idle)
- **win**: Character victory pose (stays on last frame)
- **lose**: Character defeat pose (non-looping, auto-returns to idle)

## Direction Support

- **right**: Character faces right (towards mob) - **Default for characters**
- **left**: Character faces left (away from mob)

The system will:
1. First check for direction-specific folder (e.g., `idle/right/`)
2. Fallback to base folder (e.g., `idle/`) if direction folder doesn't exist

## File Naming

- Files must be named sequentially: `01.png`, `02.png`, `03.png`, etc.
- Use zero-padding (01, not 1)
- The system will automatically detect the sequence length
- Stops checking after 3 consecutive missing frames

## Usage in Code

```blade
<x-character-animation 
    :character="$character"
    state="idle"
    direction="right"
    :autoplay="true"
/>
```

## Adding New Characters

1. Create a folder: `public/assets/characters/{character-slug}/`
2. Add animation state folders (e.g., `idle/`, `fight/`)
3. Add direction subfolders if needed (e.g., `idle/right/`)
4. Add PNG sequence files (01.png, 02.png, etc.)

## Testing

Visit `/characters/test-animations` to test individual character animations.
Visit `/characters/test-fight` to test character vs mob fight animations.
