# Mob Animation Assets

This directory contains PNG sequence animations for mobs (enemies).

## Folder Structure

Each mob has its own folder named after the mob's slug.

### Base Structure (No Direction)
```
assets/mobs/{mob-slug}/
├── idle/
│   ├── 01.png
│   ├── 02.png
│   └── ...
├── attack/
│   ├── 01.png
│   ├── 02.png
│   └── ...
├── magic/
│   ├── 01.png
│   └── ...
├── win/
│   ├── 01.png
│   └── ...
└── lose/
    ├── 01.png
    └── ...
```

### With Direction Support (Recommended)
```
assets/mobs/{mob-slug}/
├── idle/
│   ├── left/       (facing left, towards character)
│   │   ├── 01.png
│   │   ├── 02.png
│   │   └── ...
│   └── right/      (facing right, away from character)
│       ├── 01.png
│       └── ...
├── attack/
│   ├── left/
│   │   ├── 01.png
│   │   └── ...
│   └── right/
│       ├── 01.png
│       └── ...
└── ...
```

## Animation States

- **idle**: Mob standing still (looping)
- **attack**: Mob attacking (non-looping, auto-returns to idle)
- **magic**: Mob casting magic (looping, auto-returns to idle)
- **win**: Mob victory pose (stays on last frame)
- **lose**: Mob defeat pose (non-looping, auto-returns to idle)

## Direction Support

- **left**: Mob faces left (towards character) - **Default for mobs**
- **right**: Mob faces right (away from character)

The system will:
1. First check for direction-specific folder (e.g., `idle/left/`)
2. Fallback to base folder (e.g., `idle/`) if direction folder doesn't exist

## File Naming

- Files must be named sequentially: `01.png`, `02.png`, `03.png`, etc.
- Use zero-padding (01, not 1)
- The system will automatically detect the sequence length
- Stops checking after 3 consecutive missing frames

## Usage in Code

```blade
<x-mob-animation 
    :mob="$mob"
    state="idle"
    direction="left"
    :autoplay="true"
/>
```

## Adding New Mobs

1. Create a folder: `public/assets/mobs/{mob-slug}/`
2. Add animation state folders (e.g., `idle/`, `attack/`)
3. Add direction subfolders if needed (e.g., `idle/left/`)
4. Add PNG sequence files (01.png, 02.png, etc.)

## Testing

Visit `/characters/test-fight` to test mob animations alongside character animations.


