import './bootstrap';

import Alpine from 'alpinejs';
import CharacterAnimator from './CharacterAnimator.js';

window.Alpine = Alpine;
window.CharacterAnimator = CharacterAnimator;

// Egyptian Theme Animations
Alpine.data('egyptianAnimations', () => ({
    init() {
        // Listen for quest completion
        window.addEventListener('quest-completed', () => {
            this.animateQuestCompletion();
        });

        // Listen for level up
        window.addEventListener('level-up', () => {
            this.animateLevelUp();
        });
    },
    
    animateQuestCompletion() {
        // Create golden light traveling upward effect
        const light = document.createElement('div');
        light.className = 'fixed inset-0 pointer-events-none z-50';
        light.style.cssText = 'background: linear-gradient(to top, rgba(212, 175, 55, 0.6) 0%, transparent 100%); animation: fadeOut 1s ease-out forwards;';
        document.body.appendChild(light);
        
        setTimeout(() => {
            light.remove();
        }, 1000);
    },
    
    animateLevelUp() {
        // Flash of sunlight across screen
        const flash = document.createElement('div');
        flash.className = 'fixed inset-0 pointer-events-none z-50';
        flash.style.cssText = 'background: radial-gradient(circle, rgba(212, 175, 55, 0.8) 0%, transparent 70%); animation: flash 0.5s ease-out forwards;';
        document.body.appendChild(flash);
        
        // Level up notification
        const notification = document.createElement('div');
        notification.className = 'fixed top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 z-50 pointer-events-none';
        notification.innerHTML = '<div class="font-egyptian text-6xl text-ra-gold text-shadow-gold animate-gold-pulse">👁️ Ra has blessed you — Level Up!</div>';
        notification.style.animation = 'fadeInOut 3s ease-in-out forwards';
        document.body.appendChild(notification);
        
        setTimeout(() => {
            flash.remove();
            notification.remove();
        }, 3000);
    }
}));

// Add CSS animations if not already in CSS
const style = document.createElement('style');
style.textContent = `
    @keyframes fadeOut {
        to { opacity: 0; }
    }
    @keyframes flash {
        0%, 100% { opacity: 0; }
        50% { opacity: 1; }
    }
    @keyframes fadeInOut {
        0%, 100% { opacity: 0; transform: translate(-50%, -50%) scale(0.8); }
        50% { opacity: 1; transform: translate(-50%, -50%) scale(1); }
    }
`;
document.head.appendChild(style);

Alpine.start();
