<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            {{ __('Create Arena 3 Background') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="{{ route('admin.arena3-backgrounds.store') }}" enctype="multipart/form-data">
                    @csrf

                    <!-- Basic Information -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Basic Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-egyptian text-ra-gold mb-2">Background Name *</label>
                                <input type="text" id="name" name="name" value="{{ old('name') }}" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('name') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="sort_order" class="block text-sm font-egyptian text-ra-gold mb-2">Sort Order</label>
                                <input type="number" id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Lower numbers appear first</p>
                                @error('sort_order') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mt-4">
                            <label for="description" class="block text-sm font-egyptian text-ra-gold mb-2">Description</label>
                            <textarea id="description" name="description" rows="3"
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">{{ old('description') }}</textarea>
                            @error('description') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    <!-- Images -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Background Images</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="image" class="block text-sm font-egyptian text-ra-gold mb-2">Background Image *</label>
                                <input type="file" id="image" name="image" accept="image/*" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Main background image for Arena 3</p>
                                @error('image') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="shop_image" class="block text-sm font-egyptian text-ra-gold mb-2">Shop Animation Image (Optional)</label>
                                <input type="file" id="shop_image" name="shop_image" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Optional shop animation overlay</p>
                                @error('shop_image') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Unlock Conditions -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Unlock Conditions</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="unlock_level" class="block text-sm font-egyptian text-ra-gold mb-2">Unlock Level</label>
                                <input type="number" id="unlock_level" name="unlock_level" value="{{ old('unlock_level') }}" min="1"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="Leave empty for shop only">
                                <p class="text-xs text-desert-sand/70 mt-1">Level required to unlock</p>
                                @error('unlock_level') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="cost_gold" class="block text-sm font-egyptian text-ra-gold mb-2">Gold Cost</label>
                                <input type="number" id="cost_gold" name="cost_gold" value="{{ old('cost_gold') }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="0 or leave empty">
                                @error('cost_gold') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="cost_premium" class="block text-sm font-egyptian text-ra-gold mb-2">Premium Coins Cost</label>
                                <input type="number" id="cost_premium" name="cost_premium" value="{{ old('cost_premium') }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="0 or leave empty">
                                @error('cost_premium') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mt-4 flex items-center gap-4">
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="is_vip_only" value="1" {{ old('is_vip_only') ? 'checked' : '' }}
                                    class="w-4 h-4 text-ra-gold bg-papyrus-dark border-ra-gold/30 rounded focus:ring-ra-gold">
                                <span class="text-sm text-desert-sand">VIP Only</span>
                            </label>
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="is_default" value="1" {{ old('is_default') ? 'checked' : '' }}
                                    class="w-4 h-4 text-ra-gold bg-papyrus-dark border-ra-gold/30 rounded focus:ring-ra-gold">
                                <span class="text-sm text-desert-sand">Default Background</span>
                            </label>
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                                    class="w-4 h-4 text-ra-gold bg-papyrus-dark border-ra-gold/30 rounded focus:ring-ra-gold">
                                <span class="text-sm text-desert-sand">Active</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('admin.arena3-backgrounds.index') }}" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                            Create Background
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>

