@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('Arena 3 Backgrounds') }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.arena3-backgrounds.create') }}" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                    New Background
                </a>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Preview</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Unlock</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Cost</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($backgrounds as $background)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($background->image_path)
                                        <img src="{{ Storage::url($background->image_path) }}" alt="{{ $background->name }}" class="w-24 h-16 object-cover rounded border border-ra-gold/30">
                                    @else
                                        <div class="w-24 h-16 bg-papyrus-dark border border-ra-gold/30 rounded flex items-center justify-center text-xs text-desert-sand/50">No Image</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-egyptian text-desert-sand">{{ $background->name }}</div>
                                    @if($background->is_default)
                                        <span class="text-xs text-ra-gold">⭐ Default</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    @if($background->unlock_level)
                                        Level {{ $background->unlock_level }}
                                    @else
                                        <span class="text-desert-sand/70">Shop Only</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    @if($background->cost_gold)
                                        <span class="text-yellow-400">💰 {{ number_format($background->cost_gold) }} Gold</span>
                                    @endif
                                    @if($background->cost_premium)
                                        @if($background->cost_gold) <br> @endif
                                        <span class="text-purple-400">💎 {{ number_format($background->cost_premium) }} Premium</span>
                                    @endif
                                    @if(!$background->cost_gold && !$background->cost_premium)
                                        <span class="text-green-400">Free</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($background->is_active)
                                        <span class="px-2 py-1 text-xs rounded bg-green-500/20 text-green-400 border border-green-500/30">Active</span>
                                    @else
                                        <span class="px-2 py-1 text-xs rounded bg-red-500/20 text-red-400 border border-red-500/30">Inactive</span>
                                    @endif
                                    @if($background->is_vip_only)
                                        <span class="px-2 py-1 text-xs rounded bg-purple-500/20 text-purple-400 border border-purple-500/30 mt-1 block">VIP Only</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex gap-2">
                                        <a href="{{ route('admin.arena3-backgrounds.edit', $background) }}" class="text-nile-turquoise hover:text-nile-turquoise/80">Edit</a>
                                        <form method="POST" action="{{ route('admin.arena3-backgrounds.destroy', $background) }}" class="inline" onsubmit="return confirm('Are you sure you want to delete this background?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-blood-red hover:text-blood-red/80">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-desert-sand">
                                    No backgrounds found. <a href="{{ route('admin.arena3-backgrounds.create') }}" class="text-ra-gold hover:underline">Create one</a>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $backgrounds->links() }}
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

