<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            {{ __('Arena 3 Combat Logs') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                    View logs to verify that characters and mobs are using the stats configured in the admin panel.
                    Logs show base stats, bonuses, and final calculated values for Arena 3.
                </p>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                    ← Back to Admin Dashboard
                </a>
            </div>

            @if(empty($logs))
                <div class="quest-card">
                    <p class="text-desert-sand text-center py-8">
                        No Arena 3 logs found yet. Enter Arena 3 to generate logs.
                    </p>
                </div>
            @else
                <div class="space-y-4">
                    @foreach($logs as $log)
                        <div class="quest-card">
                            <div class="flex items-center justify-between mb-3">
                                <h3 class="font-egyptian text-lg {{ $log['type'] === 'Character' ? 'text-nile-turquoise' : 'text-blood-red' }}">
                                    {{ $log['type'] }} Stats - {{ $log['data']['character_name'] ?? $log['data']['mob_name'] ?? 'Unknown' }}
                                </h3>
                                <span class="text-xs text-desert-sand/70">{{ $log['timestamp'] }}</span>
                            </div>
                            
                            @if($log['type'] === 'Character')
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-nile-turquoise/30">
                                        <div class="text-sm font-egyptian text-nile-turquoise mb-2">HP</div>
                                        <div class="text-xs text-desert-sand/70">Base: {{ $log['data']['base_hp'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70">Bonus: {{ $log['data']['hp_bonus'] ?? 0 }}</div>
                                        <div class="text-lg font-bold text-nile-turquoise mt-1">Final: {{ $log['data']['final_hp'] ?? 'N/A' }}</div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-blood-red/30">
                                        <div class="text-sm font-egyptian text-blood-red mb-2">Attack</div>
                                        <div class="text-xs text-desert-sand/70">Base: {{ $log['data']['base_attack'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70">Bonus: {{ $log['data']['attack_bonus'] ?? 0 }}</div>
                                        <div class="text-lg font-bold text-blood-red mt-1">Final: {{ $log['data']['final_attack'] ?? 'N/A' }}</div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-ra-gold/30">
                                        <div class="text-sm font-egyptian text-ra-gold mb-2">Defense</div>
                                        <div class="text-xs text-desert-sand/70">Base: {{ $log['data']['base_defense'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70">Bonus: {{ $log['data']['defense_bonus'] ?? 0 }}</div>
                                        <div class="text-lg font-bold text-ra-gold mt-1">Final: {{ $log['data']['final_defense'] ?? 'N/A' }}</div>
                                    </div>
                                </div>
                                <div class="mt-3 text-xs text-desert-sand/70">
                                    Character ID: {{ $log['data']['character_id'] ?? 'N/A' }} | 
                                    Slug: {{ $log['data']['character_slug'] ?? 'N/A' }}
                                </div>
                            @else
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-nile-turquoise/30">
                                        <div class="text-sm font-egyptian text-nile-turquoise mb-2">HP</div>
                                        <div class="text-xs text-desert-sand/70">Original: {{ $log['data']['original_hp'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70 {{ $log['data']['hp_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400' }}">
                                            {{ $log['data']['hp_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is' }}
                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: {{ $log['data']['hp_ratio'] ?? 'N/A' }}</div>
                                        <div class="text-lg font-bold text-nile-turquoise mt-1">Final: {{ $log['data']['final_hp'] ?? 'N/A' }}</div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-blood-red/30">
                                        <div class="text-sm font-egyptian text-blood-red mb-2">Attack</div>
                                        <div class="text-xs text-desert-sand/70">Original: {{ $log['data']['original_attack'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70 {{ $log['data']['attack_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400' }}">
                                            {{ $log['data']['attack_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is' }}
                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: {{ $log['data']['attack_ratio'] ?? 'N/A' }}</div>
                                        <div class="text-lg font-bold text-blood-red mt-1">Final: {{ $log['data']['final_attack'] ?? 'N/A' }}</div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-ra-gold/30">
                                        <div class="text-sm font-egyptian text-ra-gold mb-2">Defense</div>
                                        <div class="text-xs text-desert-sand/70">Original: {{ $log['data']['original_defense'] ?? 'N/A' }}</div>
                                        <div class="text-xs text-desert-sand/70 {{ $log['data']['defense_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400' }}">
                                            {{ $log['data']['defense_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is' }}
                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: {{ $log['data']['defense_ratio'] ?? 'N/A' }}</div>
                                        <div class="text-lg font-bold text-ra-gold mt-1">Final: {{ $log['data']['final_defense'] ?? 'N/A' }}</div>
                                    </div>
                                </div>
                                <div class="mt-3 text-xs text-desert-sand/70">
                                    Mob ID: {{ $log['data']['mob_id'] ?? 'N/A' }} | 
                                    Slug: {{ $log['data']['mob_slug'] ?? 'N/A' }}
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</x-app-layout>

