@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            {{ __('Edit Character') }}: {{ $character->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="{{ route('admin.characters.update', $character) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <!-- Basic Information -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Basic Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-egyptian text-ra-gold mb-2">Character Name *</label>
                                <input type="text" id="name" name="name" value="{{ old('name', $character->name) }}" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('name') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="rarity" class="block text-sm font-egyptian text-ra-gold mb-2">Rarity *</label>
                                <select id="rarity" name="rarity" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <option value="common" {{ old('rarity', $character->rarity) == 'common' ? 'selected' : '' }}>Common</option>
                                    <option value="rare" {{ old('rarity', $character->rarity) == 'rare' ? 'selected' : '' }}>Rare</option>
                                    <option value="epic" {{ old('rarity', $character->rarity) == 'epic' ? 'selected' : '' }}>Epic</option>
                                    <option value="legendary" {{ old('rarity', $character->rarity) == 'legendary' ? 'selected' : '' }}>Legendary</option>
                                </select>
                                @error('rarity') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mt-4">
                            <label for="description" class="block text-sm font-egyptian text-ra-gold mb-2">Description</label>
                            <textarea id="description" name="description" rows="3"
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">{{ old('description', $character->description) }}</textarea>
                            @error('description') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    <!-- Unlock Conditions -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Unlock Conditions</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="unlock_level" class="block text-sm font-egyptian text-ra-gold mb-2">Unlock Level</label>
                                <input type="number" id="unlock_level" name="unlock_level" value="{{ old('unlock_level', $character->unlock_level) }}" min="1"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="Leave empty for shop only">
                                <p class="text-xs text-desert-sand/70 mt-1">Level required to unlock</p>
                                @error('unlock_level') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="cost_gold" class="block text-sm font-egyptian text-ra-gold mb-2">Gold Cost</label>
                                <input type="number" id="cost_gold" name="cost_gold" value="{{ old('cost_gold', $character->cost_gold) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="0 or leave empty">
                                @error('cost_gold') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="cost_premium" class="block text-sm font-egyptian text-ra-gold mb-2">Premium Coins Cost</label>
                                <input type="number" id="cost_premium" name="cost_premium" value="{{ old('cost_premium', $character->cost_premium) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="0 or leave empty">
                                @error('cost_premium') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mt-4 flex items-center gap-4">
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="is_vip_only" value="1" {{ old('is_vip_only', $character->is_vip_only) ? 'checked' : '' }}
                                    class="w-4 h-4 text-ra-gold bg-papyrus-dark border-ra-gold/30 rounded focus:ring-ra-gold">
                                <span class="text-sm text-desert-sand">VIP Only</span>
                            </label>
                        </div>
                    </div>

                    <!-- Stat Bonuses -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Stat Bonuses</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <div>
                                <label for="hp_bonus" class="block text-sm font-egyptian text-ra-gold mb-2">HP Bonus</label>
                                <input type="number" id="hp_bonus" name="hp_bonus" value="{{ old('hp_bonus', $character->hp_bonus) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('hp_bonus') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="attack_bonus" class="block text-sm font-egyptian text-ra-gold mb-2">Attack Bonus</label>
                                <input type="number" id="attack_bonus" name="attack_bonus" value="{{ old('attack_bonus', $character->attack_bonus) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('attack_bonus') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="defense_bonus" class="block text-sm font-egyptian text-ra-gold mb-2">Defense Bonus</label>
                                <input type="number" id="defense_bonus" name="defense_bonus" value="{{ old('defense_bonus', $character->defense_bonus) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('defense_bonus') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="stamina_bonus" class="block text-sm font-egyptian text-ra-gold mb-2">Stamina Bonus</label>
                                <input type="number" id="stamina_bonus" name="stamina_bonus" value="{{ old('stamina_bonus', $character->stamina_bonus) }}" min="0"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                @error('stamina_bonus') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Base Stats for Arena 3 -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Base Stats for Arena 3</h3>
                        <p class="text-sm text-desert-sand mb-4">
                            Control the base HP, Attack, and Defense for this character in Arena 3. 
                            If left empty, defaults will be used (HP: 200, Attack: 50, Defense: 20).
                            Bonuses are added on top of these base values.
                        </p>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="base_hp" class="block text-sm font-egyptian text-nile-turquoise mb-2">Base HP</label>
                                <input type="number" id="base_hp" name="base_hp" value="{{ old('base_hp', $character->base_hp) }}" min="1"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-nile-turquoise/30 rounded text-desert-sand focus:border-nile-turquoise focus:outline-none"
                                    placeholder="Default: 200">
                                <p class="text-xs text-desert-sand/70 mt-1">Final HP = Base HP + HP Bonus</p>
                                @error('base_hp') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="base_attack" class="block text-sm font-egyptian text-blood-red mb-2">Base Attack</label>
                                <input type="number" id="base_attack" name="base_attack" value="{{ old('base_attack', $character->base_attack) }}" min="1"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-blood-red/30 rounded text-desert-sand focus:border-blood-red focus:outline-none"
                                    placeholder="Default: 50">
                                <p class="text-xs text-desert-sand/70 mt-1">Final Attack = Base Attack + Attack Bonus</p>
                                @error('base_attack') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="base_defense" class="block text-sm font-egyptian text-ra-gold mb-2">Base Defense</label>
                                <input type="number" id="base_defense" name="base_defense" value="{{ old('base_defense', $character->base_defense) }}" min="1"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="Default: 20">
                                <p class="text-xs text-desert-sand/70 mt-1">Final Defense = Base Defense + Defense Bonus</p>
                                @error('base_defense') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Images -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Character Images</h3>
                        
                        <!-- Idle State -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Idle State</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="image_idle" class="block text-sm font-egyptian text-ra-gold mb-2">Idle Image (Static)</label>
                                    @if($character->image_idle)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_idle) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_idle" name="image_idle" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_idle') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="image_idle_animation" class="block text-sm font-egyptian text-ra-gold mb-2">Idle Animation</label>
                                    @if($character->image_idle_animation)
                                        <div class="mb-2">
                                            @if(str_ends_with($character->image_idle_animation, '.gif'))
                                                <img src="{{ Storage::url($character->image_idle_animation) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            @else
                                                <video src="{{ Storage::url($character->image_idle_animation) }}" class="w-24 h-24 object-cover rounded border border-ra-gold/30" muted loop></video>
                                            @endif
                                            <p class="text-xs text-desert-sand/70 mt-1">Current animation</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_idle_animation" name="image_idle_animation" accept="image/gif,video/mp4,video/webm"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">GIF or video (leave empty to keep current)</p>
                                    @error('image_idle_animation') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Winning State -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Winning State</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="image_winning" class="block text-sm font-egyptian text-ra-gold mb-2">Winning Image (Static)</label>
                                    @if($character->image_winning)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_winning) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_winning" name="image_winning" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_winning') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="image_winning_animation" class="block text-sm font-egyptian text-ra-gold mb-2">Winning Animation</label>
                                    @if($character->image_winning_animation)
                                        <div class="mb-2">
                                            @if(str_ends_with($character->image_winning_animation, '.gif'))
                                                <img src="{{ Storage::url($character->image_winning_animation) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            @else
                                                <video src="{{ Storage::url($character->image_winning_animation) }}" class="w-24 h-24 object-cover rounded border border-ra-gold/30" muted loop></video>
                                            @endif
                                            <p class="text-xs text-desert-sand/70 mt-1">Current animation</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_winning_animation" name="image_winning_animation" accept="image/gif,video/mp4,video/webm"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">GIF or video (leave empty to keep current)</p>
                                    @error('image_winning_animation') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Lost State -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Lost State</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="image_lost" class="block text-sm font-egyptian text-ra-gold mb-2">Lost Image (Static)</label>
                                    @if($character->image_lost)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_lost) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_lost" name="image_lost" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_lost') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="image_lost_animation" class="block text-sm font-egyptian text-ra-gold mb-2">Lost Animation</label>
                                    @if($character->image_lost_animation)
                                        <div class="mb-2">
                                            @if(str_ends_with($character->image_lost_animation, '.gif'))
                                                <img src="{{ Storage::url($character->image_lost_animation) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            @else
                                                <video src="{{ Storage::url($character->image_lost_animation) }}" class="w-24 h-24 object-cover rounded border border-ra-gold/30" muted loop></video>
                                            @endif
                                            <p class="text-xs text-desert-sand/70 mt-1">Current animation</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_lost_animation" name="image_lost_animation" accept="image/gif,video/mp4,video/webm"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">GIF or video (leave empty to keep current)</p>
                                    @error('image_lost_animation') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Legacy Images (for backward compatibility) -->
                        <div class="mb-4 p-4 bg-papyrus-dark/30 rounded-lg border border-ra-gold/20">
                            <h4 class="font-egyptian text-sm text-desert-sand/70 mb-3">Legacy Images (Optional - for backward compatibility)</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <label for="image_normal" class="block text-sm font-egyptian text-ra-gold mb-2">Normal Image</label>
                                    @if($character->image_normal)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_normal) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_normal" name="image_normal" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_normal') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="image_win" class="block text-sm font-egyptian text-ra-gold mb-2">Win Image</label>
                                    @if($character->image_win)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_win) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_win" name="image_win" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_win') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="image_loss" class="block text-sm font-egyptian text-ra-gold mb-2">Loss Image</label>
                                    @if($character->image_loss)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($character->image_loss) }}" alt="Current" class="w-24 h-24 object-cover rounded border border-ra-gold/30">
                                            <p class="text-xs text-desert-sand/70 mt-1">Current image</p>
                                        </div>
                                    @endif
                                    <input type="file" id="image_loss" name="image_loss" accept="image/*"
                                        class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                    <p class="text-xs text-desert-sand/70 mt-1">Leave empty to keep current</p>
                                    @error('image_loss') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- PNG Sequences for Arena 3 -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">PNG Sequences for Arena 3</h3>
                        <p class="text-sm text-desert-sand/70 mb-4">Upload 5 PNG files for each animation state. Files will be automatically numbered (01.png, 02.png, etc.). Leave empty to keep current sequences.</p>
                        
                        <!-- Show current sequences if they exist -->
                        @php
                            $characterSlug = $character->slug;
                            $states = ['idle', 'fight', 'win', 'lose'];
                            $currentSequences = [];
                            foreach ($states as $state) {
                                $folderPath = public_path("assets/characters/{$characterSlug}/{$state}");
                                if (is_dir($folderPath)) {
                                    $files = glob("{$folderPath}/*.png");
                                    natsort($files);
                                    $currentSequences[$state] = count($files);
                                }
                            }
                        @endphp
                        
                        @if(count($currentSequences) > 0)
                        <div class="mb-4 p-3 bg-nile-turquoise/20 border border-nile-turquoise/30 rounded-lg">
                            <p class="text-sm text-nile-turquoise font-semibold mb-2">Current Sequences:</p>
                            <div class="grid grid-cols-4 gap-2 text-xs text-desert-sand">
                                @foreach($states as $state)
                                    <div>
                                        <span class="font-semibold">{{ ucfirst($state) }}:</span>
                                        <span>{{ $currentSequences[$state] ?? 0 }} frames</span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        @endif
                        
                        <!-- Idle Sequence -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Idle Animation (5 frames)</h4>
                            <input type="file" id="png_idle[]" name="png_idle[]" accept="image/png" multiple
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <p class="text-xs text-desert-sand/70 mt-1">Select 5 PNG files to replace current idle animation</p>
                            @error('png_idle') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>

                        <!-- Fight Sequence -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Fight/Attack Animation (5 frames)</h4>
                            <input type="file" id="png_fight[]" name="png_fight[]" accept="image/png" multiple
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <p class="text-xs text-desert-sand/70 mt-1">Select 5 PNG files to replace current fight animation</p>
                            @error('png_fight') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>

                        <!-- Win Sequence -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Win Animation (5 frames)</h4>
                            <input type="file" id="png_win[]" name="png_win[]" accept="image/png" multiple
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <p class="text-xs text-desert-sand/70 mt-1">Select 5 PNG files to replace current win animation</p>
                            @error('png_win') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>

                        <!-- Lose Sequence -->
                        <div class="mb-4 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                            <h4 class="font-egyptian text-lg text-ra-gold mb-3">Lose Animation (5 frames)</h4>
                            <input type="file" id="png_lose[]" name="png_lose[]" accept="image/png" multiple
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <p class="text-xs text-desert-sand/70 mt-1">Select 5 PNG files to replace current lose animation</p>
                            @error('png_lose') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    <!-- Videos -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Character Videos</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="video_url" class="block text-sm font-egyptian text-ra-gold mb-2">Normal Video URL</label>
                                <input type="url" id="video_url" name="video_url" value="{{ old('video_url', $character->video_url) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="https://example.com/video.mp4">
                                @if($character->video_url)
                                    <p class="text-xs text-nile-turquoise mt-1">Current: {{ $character->video_url }}</p>
                                @endif
                                <p class="text-xs text-desert-sand/70 mt-1">Default character video</p>
                                @error('video_url') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="video_win" class="block text-sm font-egyptian text-ra-gold mb-2">Win Video URL</label>
                                <input type="url" id="video_win" name="video_win" value="{{ old('video_win', $character->video_win) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="https://example.com/win.mp4">
                                @if($character->video_win)
                                    <p class="text-xs text-nile-turquoise mt-1">Current: {{ $character->video_win }}</p>
                                @endif
                                <p class="text-xs text-desert-sand/70 mt-1">Shown when character wins</p>
                                @error('video_win') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="video_loss" class="block text-sm font-egyptian text-ra-gold mb-2">Loss Video URL</label>
                                <input type="url" id="video_loss" name="video_loss" value="{{ old('video_loss', $character->video_loss) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="https://example.com/loss.mp4">
                                @if($character->video_loss)
                                    <p class="text-xs text-nile-turquoise mt-1">Current: {{ $character->video_loss }}</p>
                                @endif
                                <p class="text-xs text-desert-sand/70 mt-1">Shown when character loses</p>
                                @error('video_loss') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Additional Settings -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Additional Settings</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="sprite_source" class="block text-sm font-egyptian text-ra-gold mb-2">Sprite Source URL</label>
                                <input type="text" id="sprite_source" name="sprite_source" value="{{ old('sprite_source', $character->sprite_source) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none"
                                    placeholder="/assets/sprites/character.png">
                                @error('sprite_source') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="sort_order" class="block text-sm font-egyptian text-ra-gold mb-2">Sort Order</label>
                                <input type="number" id="sort_order" name="sort_order" value="{{ old('sort_order', $character->sort_order) }}"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Lower numbers appear first</p>
                                @error('sort_order') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mt-4 flex items-center gap-4">
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $character->is_active) ? 'checked' : '' }}
                                    class="w-4 h-4 text-ra-gold bg-papyrus-dark border-ra-gold/30 rounded focus:ring-ra-gold">
                                <span class="text-sm text-desert-sand">Active (visible to users)</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('admin.characters.index') }}" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                            Update Character
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>

