@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('Character Management') }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.characters.create') }}" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                    New Character
                </a>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Image</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Unlock</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Cost</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Bonuses</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rarity</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($characters as $character)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($character->image_normal)
                                        <img src="{{ Storage::url($character->image_normal) }}" alt="{{ $character->name }}" class="w-16 h-16 object-cover rounded border border-ra-gold/30">
                                    @else
                                        <div class="w-16 h-16 bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border border-ra-gold/30 rounded flex items-center justify-center">
                                            <span class="text-2xl">👤</span>
                                        </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-egyptian text-ra-gold">{{ $character->name }}</div>
                                    @if($character->description)
                                        <div class="text-xs text-desert-sand/70 mt-1">{{ Str::limit($character->description, 50) }}</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($character->unlock_level)
                                        <span class="text-nile-turquoise">Rank {{ $character->unlock_level }}</span>
                                    @else
                                        <span class="text-desert-sand/50">Shop Only</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($character->cost_gold)
                                        <div class="text-ra-gold">💰 {{ number_format($character->cost_gold) }}</div>
                                    @endif
                                    @if($character->cost_premium)
                                        <div class="text-nile-turquoise">💎 {{ number_format($character->cost_premium) }}</div>
                                    @endif
                                    @if(!$character->cost_gold && !$character->cost_premium)
                                        <span class="text-desert-sand/50">Free</span>
                                    @endif
                                    @if($character->is_vip_only)
                                        <div class="text-yellow-400 text-xs mt-1">VIP Only</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-xs">
                                    @if($character->hp_bonus > 0)
                                        <div class="text-nile-turquoise">+{{ $character->hp_bonus }} HP</div>
                                    @endif
                                    @if($character->attack_bonus > 0)
                                        <div class="text-blood-red">+{{ $character->attack_bonus }} Attack</div>
                                    @endif
                                    @if($character->defense_bonus > 0)
                                        <div class="text-nile-turquoise">+{{ $character->defense_bonus }} Defense</div>
                                    @endif
                                    @if($character->stamina_bonus > 0)
                                        <div class="text-purple-300">+{{ $character->stamina_bonus }} Stamina</div>
                                    @endif
                                    @if(!$character->hp_bonus && !$character->attack_bonus && !$character->defense_bonus && !$character->stamina_bonus)
                                        <span class="text-desert-sand/50">None</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded border
                                        @if($character->rarity === 'legendary') border-yellow-400 text-yellow-400
                                        @elseif($character->rarity === 'epic') border-purple-400 text-purple-400
                                        @elseif($character->rarity === 'rare') border-blue-400 text-blue-400
                                        @else border-gray-400 text-gray-400
                                        @endif">
                                        {{ ucfirst($character->rarity) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($character->is_active)
                                        <span class="px-2 py-1 text-xs bg-green-900/50 text-green-300 rounded">Active</span>
                                    @else
                                        <span class="px-2 py-1 text-xs bg-red-900/50 text-red-300 rounded">Inactive</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex gap-2">
                                        <a href="{{ route('admin.characters.edit', $character) }}" class="text-nile-turquoise hover:text-teal-300">Edit</a>
                                        <form method="POST" action="{{ route('admin.characters.destroy', $character) }}" class="inline" onsubmit="return confirm('Are you sure you want to delete this character?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-blood-red hover:text-red-400">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="px-6 py-4 text-center text-desert-sand">
                                    No characters found. <a href="{{ route('admin.characters.create') }}" class="text-ra-gold hover:underline">Create one</a>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $characters->links() }}
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

