<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">👑</span>
            <span>Admin Temple</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Users</h3>
                    <p class="font-stat text-3xl text-nile-turquoise mb-2">{{ $totalUsers }}</p>
                    <p class="text-sm text-desert-sand">Total Users</p>
                    <div class="mt-3 space-y-1 text-sm text-desert-sand">
                        <p>{{ $activeUsers }} active this week</p>
                        <p>{{ $totalAdmins }} admins</p>
                    </div>
                </div>

                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Quests</h3>
                    <p class="font-stat text-3xl text-green-400 mb-2">{{ $completedTasks }} / {{ $totalTasks }}</p>
                    <p class="text-sm text-desert-sand">{{ number_format($completionRate, 1) }}% Completion Rate</p>
                    <p class="text-sm text-desert-sand mt-3">{{ $tasksToday }} completed today</p>
                </div>

                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Battles</h3>
                    <p class="font-stat text-3xl text-blood-red mb-2">{{ $totalBattles }}</p>
                    <p class="text-sm text-desert-sand">{{ number_format($winRate, 1) }}% Win Rate</p>
                    <p class="text-sm text-desert-sand mt-3">{{ $battlesWon }} victories</p>
                </div>
            </div>

            <!-- Game Stats -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Average Game Stats</h3>
                <div class="grid grid-cols-3 gap-4">
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-nile-turquoise/30">
                        <div class="font-stat text-2xl text-nile-turquoise mb-1">{{ number_format($avgXP) }}</div>
                        <div class="text-xs text-desert-sand">Average Divine Energy</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <div class="font-stat text-2xl text-ra-gold mb-1">{{ number_format($avgGold) }}</div>
                        <div class="text-xs text-desert-sand">Average Sacred Gold</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-purple-400/30">
                        <div class="font-stat text-2xl text-purple-300 mb-1">{{ number_format($avgLevel, 1) }}</div>
                        <div class="text-xs text-desert-sand">Average Rank</div>
                    </div>
                </div>
            </div>

            <!-- Leaderboard -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Top Champions</h3>
                <div class="space-y-2">
                    @foreach($leaderboard as $index => $user)
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 hover:bg-papyrus-dark rounded-lg border border-ra-gold/20 transition-all duration-300">
                        <div class="flex items-center gap-3">
                            <span class="font-egyptian text-ra-gold w-8">#{{ $index + 1 }}</span>
                            <span class="text-desert-sand">{{ $user->name }}</span>
                        </div>
                        <div class="flex gap-4 text-sm">
                            <span class="font-stat text-nile-turquoise">Rank {{ $user->level }}</span>
                            <span class="text-desert-sand">{{ number_format($user->xp) }} ✨</span>
                            <span class="text-ra-gold">💰 {{ number_format($user->gold) }}</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Popular Items -->
            @if($popularItems->count() > 0)
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Most Popular Relics</h3>
                <div class="space-y-2">
                    @foreach($popularItems as $item)
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 hover:bg-papyrus-dark rounded-lg border border-ra-gold/20 transition-all duration-300">
                        <span class="text-desert-sand">{{ $item->name }}</span>
                        <span class="text-sm text-nile-turquoise font-stat">{{ $item->user_items_count }} owners</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Category Stats -->
            @if($categoryStats->count() > 0)
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Scroll Completion Rates</h3>
                <div class="space-y-3">
                    @foreach($categoryStats as $cat)
                    <div>
                        <div class="flex justify-between mb-1 text-desert-sand">
                            <span>{{ $cat->name }}</span>
                            <span class="text-sm font-stat text-nile-turquoise">{{ number_format($cat->completion_rate, 1) }}%</span>
                        </div>
                        <div class="w-full bg-shadow-ink rounded-full h-3 border border-ra-gold/30 overflow-hidden">
                            <div class="bg-gradient-to-r from-nile-turquoise to-teal-400 h-3 rounded-full transition-all duration-500" style="width: {{ min(100, $cat->completion_rate) }}%"></div>
                        </div>
                        <div class="text-xs text-desert-sand/70 mt-1">
                            {{ $cat->completed_tasks }} / {{ $cat->total_tasks }} quests
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Quick Links -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Admin Actions</h3>
                <div class="grid grid-cols-2 md:grid-cols-6 gap-4">
                    <a href="{{ route('admin.users') }}" class="cartouche-button text-center">
                        Manage Users
                    </a>
                    <a href="{{ route('admin.items.index') }}" class="cartouche-button bg-gradient-to-r from-nile-turquoise to-teal-500 text-center">
                        Manage Relics
                    </a>
                    <a href="{{ route('admin.enemies.index') }}" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700 text-center">
                        Manage Foes
                    </a>
                    <a href="{{ route('admin.mobs.index') }}" class="cartouche-button bg-gradient-to-r from-purple-600 to-purple-800 text-center">
                        Manage Mobs
                    </a>
                    <a href="{{ route('admin.characters.index') }}" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600 text-center">
                        Manage Characters
                    </a>
                    <a href="{{ route('admin.arena3-backgrounds.index') }}" class="cartouche-button bg-gradient-to-r from-green-600 to-emerald-700 text-white text-center hover:from-green-700 hover:to-emerald-800">
                        Arena 3 Backgrounds
                    </a>
                    <a href="{{ route('admin.arena3-logs.index') }}" class="cartouche-button bg-gradient-to-r from-purple-600 to-indigo-700 text-center">
                        Arena 3 Logs
                    </a>
                    <a href="{{ route('dashboard') }}" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-4 rounded-lg text-center transition-all duration-300">
                        User Temple
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
