<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Enemy') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.enemies.store') }}">
                        @csrf

                        <div class="mb-4">
                            <x-input-label for="name" :value="__('Enemy Name')" />
                            <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus />
                        </div>

                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div>
                                <x-input-label for="level" :value="__('Level')" />
                                <x-text-input id="level" class="block mt-1 w-full" type="number" name="level" :value="old('level')" min="1" required />
                            </div>
                            <div>
                                <x-input-label for="hp" :value="__('HP')" />
                                <x-text-input id="hp" class="block mt-1 w-full" type="number" name="hp" :value="old('hp')" min="1" required />
                            </div>
                            <div>
                                <x-input-label for="attack" :value="__('Attack')" />
                                <x-text-input id="attack" class="block mt-1 w-full" type="number" name="attack" :value="old('attack')" min="1" required />
                            </div>
                            <div>
                                <x-input-label for="defense" :value="__('Defense')" />
                                <x-text-input id="defense" class="block mt-1 w-full" type="number" name="defense" :value="old('defense', 0)" min="0" required />
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div>
                                <x-input-label for="xp_reward" :value="__('XP Reward')" />
                                <x-text-input id="xp_reward" class="block mt-1 w-full" type="number" name="xp_reward" :value="old('xp_reward')" min="0" required />
                            </div>
                            <div>
                                <x-input-label for="gold_reward" :value="__('Gold Reward')" />
                                <x-text-input id="gold_reward" class="block mt-1 w-full" type="number" name="gold_reward" :value="old('gold_reward')" min="0" required />
                            </div>
                        </div>

                        <div class="mb-4">
                            <x-input-label for="drop_item_id" :value="__('Drop Item (Optional)')" />
                            <select id="drop_item_id" name="drop_item_id" class="block mt-1 w-full rounded-md border-gray-300">
                                <option value="">None</option>
                                @foreach($items as $item)
                                    <option value="{{ $item->id }}" {{ old('drop_item_id') == $item->id ? 'selected' : '' }}>
                                        {{ $item->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-4">
                            <x-input-label for="image_url" :value="__('Image URL (Optional)')" />
                            <x-text-input id="image_url" class="block mt-1 w-full" type="url" name="image_url" :value="old('image_url')" />
                        </div>

                        <div class="flex items-center justify-end gap-4">
                            <a href="{{ route('admin.enemies.index') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                Cancel
                            </a>
                            <x-primary-button>Create Enemy</x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

