<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('Enemy Management') }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.enemies.create') }}" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                    New Enemy
                </a>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Stats</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">HP</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rewards</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Drop Item</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($enemies as $enemy)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $enemy->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise font-stat">{{ $enemy->level }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    ⚔️ {{ $enemy->attack }} 🛡️ {{ $enemy->defense }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-blood-red font-stat">{{ $enemy->hp }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    XP: <span class="text-nile-turquoise">{{ $enemy->xp_reward }}</span><br>
                                    Gold: <span class="text-ra-gold">{{ $enemy->gold_reward }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">
                                    {{ $enemy->dropItem ? $enemy->dropItem->name : 'None' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex gap-2">
                                        <a href="{{ route('admin.enemies.edit', $enemy) }}" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">Edit</a>
                                        <form method="POST" action="{{ route('admin.enemies.destroy', $enemy) }}" class="inline" 
                                            onsubmit="return confirm('Delete this enemy?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-blood-red hover:text-red-400 text-sm transition-colors">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-desert-sand">No enemies found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="mt-4">
                        {{ $enemies->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

