<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Item') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.items.store') }}">
                        @csrf

                        <div class="mb-4">
                            <x-input-label for="name" :value="__('Item Name')" />
                            <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="type" :value="__('Type')" />
                            <select id="type" name="type" class="block mt-1 w-full rounded-md border-gray-300" required>
                                <option value="weapon">Weapon</option>
                                <option value="armor">Armor</option>
                                <option value="potion">Potion</option>
                                <option value="tool">Tool</option>
                            </select>
                        </div>

                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div>
                                <x-input-label for="attack" :value="__('Attack')" />
                                <x-text-input id="attack" class="block mt-1 w-full" type="number" name="attack" :value="old('attack', 0)" min="0" required />
                            </div>
                            <div>
                                <x-input-label for="defense" :value="__('Defense')" />
                                <x-text-input id="defense" class="block mt-1 w-full" type="number" name="defense" :value="old('defense', 0)" min="0" required />
                            </div>
                            <div>
                                <x-input-label for="magic" :value="__('Magic')" />
                                <x-text-input id="magic" class="block mt-1 w-full" type="number" name="magic" :value="old('magic', 0)" min="0" required />
                            </div>
                            <div>
                                <x-input-label for="stamina" :value="__('Stamina')" />
                                <x-text-input id="stamina" class="block mt-1 w-full" type="number" name="stamina" :value="old('stamina', 0)" min="0" required />
                            </div>
                        </div>

                        <div class="mb-4">
                            <x-input-label for="cost" :value="__('Cost (Gold)')" />
                            <x-text-input id="cost" class="block mt-1 w-full" type="number" name="cost" :value="old('cost')" min="0" required />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="required_level" :value="__('Required Level')" />
                            <x-text-input id="required_level" class="block mt-1 w-full" type="number" name="required_level" :value="old('required_level', 1)" min="1" required />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="image_url" :value="__('Image URL (Optional)')" />
                            <x-text-input id="image_url" class="block mt-1 w-full" type="url" name="image_url" :value="old('image_url')" />
                        </div>

                        <div class="flex items-center justify-end gap-4">
                            <a href="{{ route('admin.items.index') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                Cancel
                            </a>
                            <x-primary-button>Create Item</x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

