<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('Item Management') }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.items.create') }}" class="cartouche-button bg-gradient-to-r from-nile-turquoise to-teal-500">
                    New Item
                </a>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Stats</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Cost</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level Req.</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($items as $item)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $item->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded border border-ra-gold/50 text-ra-gold capitalize">{{ $item->type }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    @if($item->attack > 0) ⚔️ {{ $item->attack }} @endif
                                    @if($item->defense > 0) 🛡️ {{ $item->defense }} @endif
                                    @if($item->magic > 0) ✨ {{ $item->magic }} @endif
                                    @if($item->stamina > 0) ❤️ {{ $item->stamina }} @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-ra-gold font-stat">{{ number_format($item->cost) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise">{{ $item->required_level }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex gap-2">
                                        <a href="{{ route('admin.items.edit', $item) }}" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">Edit</a>
                                        <form method="POST" action="{{ route('admin.items.destroy', $item) }}" class="inline" 
                                            onsubmit="return confirm('Delete this item?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-blood-red hover:text-red-400 text-sm transition-colors">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-desert-sand">No items found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="mt-4">
                        {{ $items->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

