@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            {{ __('Edit Mob') }}: {{ $mob->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="{{ route('admin.mobs.update', $mob) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label for="name" class="block text-sm font-egyptian text-ra-gold mb-2">Mob Name</label>
                            <input type="text" id="name" name="name" value="{{ old('name', $mob->name) }}" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            @error('name') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label for="level" class="block text-sm font-egyptian text-ra-gold mb-2">Level</label>
                            <input type="number" id="level" name="level" value="{{ old('level', $mob->level) }}" min="1" max="80" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            @error('level') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    <!-- Combat Stats for Arena 3 -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Combat Stats (Used in Arena 3)</h3>
                        <p class="text-sm text-desert-sand mb-4">
                            These stats control the mob's HP, Attack, and Defense in Arena 3. 
                            Stats will be automatically balanced to be within 10% of the character's stats for fair fights.
                        </p>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <div>
                                <label for="hp" class="block text-sm font-egyptian text-nile-turquoise mb-2">HP</label>
                                <input type="number" id="hp" name="hp" value="{{ old('hp', $mob->hp) }}" min="1" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-nile-turquoise/30 rounded text-desert-sand focus:border-nile-turquoise focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's health points</p>
                                @error('hp') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="attack" class="block text-sm font-egyptian text-blood-red mb-2">Attack</label>
                                <input type="number" id="attack" name="attack" value="{{ old('attack', $mob->attack) }}" min="1" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-blood-red/30 rounded text-desert-sand focus:border-blood-red focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's attack power</p>
                                @error('attack') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="defense" class="block text-sm font-egyptian text-ra-gold mb-2">Defense</label>
                                <input type="number" id="defense" name="defense" value="{{ old('defense', $mob->defense) }}" min="0" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's defense value</p>
                                @error('defense') <p class="text-blood-red text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                        <div>
                            <label for="speed" class="block text-sm font-egyptian text-ra-gold mb-2">Speed</label>
                            <input type="number" id="speed" name="speed" value="{{ old('speed', $mob->speed) }}" min="1" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                    </div>

                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                        <div>
                            <label for="luck" class="block text-sm font-egyptian text-ra-gold mb-2">Luck</label>
                            <input type="number" id="luck" name="luck" value="{{ old('luck', $mob->luck) }}" min="0" max="20" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="xp_reward" class="block text-sm font-egyptian text-ra-gold mb-2">XP Reward</label>
                            <input type="number" id="xp_reward" name="xp_reward" value="{{ old('xp_reward', $mob->xp_reward) }}" min="0" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="gold_reward" class="block text-sm font-egyptian text-ra-gold mb-2">Gold Reward</label>
                            <input type="number" id="gold_reward" name="gold_reward" value="{{ old('gold_reward', $mob->gold_reward) }}" min="0" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="premium_coin_chance" class="block text-sm font-egyptian text-ra-gold mb-2">Premium Coin Chance</label>
                            <input type="number" id="premium_coin_chance" name="premium_coin_chance" value="{{ old('premium_coin_chance', $mob->premium_coin_chance) }}" step="0.0001" min="0" max="1"
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="rarity" class="block text-sm font-egyptian text-ra-gold mb-2">Rarity</label>
                            <select id="rarity" name="rarity" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <option value="common" {{ old('rarity', $mob->rarity) == 'common' ? 'selected' : '' }}>Common</option>
                                <option value="rare" {{ old('rarity', $mob->rarity) == 'rare' ? 'selected' : '' }}>Rare</option>
                                <option value="epic" {{ old('rarity', $mob->rarity) == 'epic' ? 'selected' : '' }}>Epic</option>
                                <option value="legendary" {{ old('rarity', $mob->rarity) == 'legendary' ? 'selected' : '' }}>Legendary</option>
                            </select>
                        </div>
                        <div>
                            <label for="ai_type" class="block text-sm font-egyptian text-ra-gold mb-2">AI Type</label>
                            <select id="ai_type" name="ai_type" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <option value="passive" {{ old('ai_type', $mob->ai_type) == 'passive' ? 'selected' : '' }}>Passive</option>
                                <option value="aggressive" {{ old('ai_type', $mob->ai_type) == 'aggressive' ? 'selected' : '' }}>Aggressive</option>
                                <option value="strategic" {{ old('ai_type', $mob->ai_type) == 'strategic' ? 'selected' : '' }}>Strategic</option>
                            </select>
                        </div>
                    </div>

                    <!-- Image Uploads -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Battle Images</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="image_normal" class="block text-sm font-egyptian text-ra-gold mb-2">Normal Image</label>
                                @if($mob->image_normal)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($mob->image_normal) }}" alt="Normal" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                @endif
                                <input type="file" id="image_normal" name="image_normal" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown during battle</p>
                            </div>
                            <div>
                                <label for="image_win" class="block text-sm font-egyptian text-ra-gold mb-2">Win Image</label>
                                @if($mob->image_win)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($mob->image_win) }}" alt="Win" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                @endif
                                <input type="file" id="image_win" name="image_win" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown when mob wins</p>
                            </div>
                            <div>
                                <label for="image_loss" class="block text-sm font-egyptian text-ra-gold mb-2">Loss Image</label>
                                @if($mob->image_loss)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($mob->image_loss) }}" alt="Loss" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                @endif
                                <input type="file" id="image_loss" name="image_loss" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown when mob loses</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('admin.mobs.index') }}" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                            Update Mob
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
