@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('Mob Management') }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.mobs.create') }}" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                    New Mob
                </a>
                <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Image</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Stats</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">HP</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rarity</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rewards</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($mobs as $mob)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($mob->image_normal)
                                        <img src="{{ Storage::url($mob->image_normal) }}" alt="{{ $mob->name }}" class="w-16 h-16 object-cover rounded border border-ra-gold/30">
                                    @else
                                        <div class="w-16 h-16 bg-papyrus-dark border border-ra-gold/30 rounded flex items-center justify-center text-2xl">👹</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand font-egyptian">{{ $mob->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise font-stat">{{ $mob->level }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    ⚔️ {{ $mob->attack }} 🛡️ {{ $mob->defense }}<br>
                                    <span class="text-xs">⚡ {{ $mob->speed }} 🍀 {{ $mob->luck }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-blood-red font-stat">{{ $mob->hp }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded border
                                        @if($mob->rarity === 'legendary') border-yellow-400 text-yellow-400
                                        @elseif($mob->rarity === 'epic') border-purple-400 text-purple-400
                                        @elseif($mob->rarity === 'rare') border-blue-400 text-blue-400
                                        @else border-gray-400 text-gray-400
                                        @endif">
                                        {{ ucfirst($mob->rarity) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    XP: <span class="text-nile-turquoise">{{ $mob->xp_reward }}</span><br>
                                    Gold: <span class="text-ra-gold">{{ $mob->gold_reward }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex gap-2">
                                        <a href="{{ route('admin.mobs.edit', $mob) }}" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">Edit</a>
                                        <form method="POST" action="{{ route('admin.mobs.destroy', $mob) }}" class="inline" 
                                            onsubmit="return confirm('Delete this mob?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-blood-red hover:text-red-400 text-sm transition-colors">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="px-6 py-4 text-center text-desert-sand">No mobs found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="mt-4">
                        {{ $mobs->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
