<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                {{ __('User Management') }}
            </h2>
            <a href="{{ route('admin.dashboard') }}" class="cartouche-button">
                Back to Dashboard
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Email</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">XP</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Gold</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Tasks</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Battles</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Admin</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            @forelse($users as $user)
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $user->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $user->email }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise font-stat">{{ $user->level }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ number_format($user->xp) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-ra-gold font-stat">{{ number_format($user->gold) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $user->tasks_count }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">{{ $user->battles_count }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($user->is_admin)
                                        <span class="px-2 py-1 text-xs rounded border border-ra-gold text-ra-gold">Admin</span>
                                    @else
                                        <span class="px-2 py-1 text-xs rounded border border-desert-sand/50 text-desert-sand">User</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <form method="POST" action="{{ route('admin.users.toggle-admin', $user) }}" class="inline">
                                        @csrf
                                        <button type="submit" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">
                                            {{ $user->is_admin ? 'Revoke Admin' : 'Make Admin' }}
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="px-6 py-4 text-center text-desert-sand">No users found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="mt-4">
                        {{ $users->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

