<x-guest-layout>
    <div class="text-center mb-6">
        <div class="text-5xl mb-2">🔒</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Confirm Password</h2>
        <p class="text-desert-sand/70 text-sm mt-2">This is a secure area. Please confirm your password.</p>
    </div>

    <form method="POST" action="{{ route('password.confirm') }}">
        @csrf

        <!-- Password -->
        <div class="mb-6">
            <label for="password" class="block text-desert-sand font-egyptian font-semibold mb-2">Password</label>
            <input id="password" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password"
                   name="password"
                   required 
                   autocomplete="current-password"
                   placeholder="••••••••">
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <div class="flex justify-end">
            <button type="submit" class="cartouche-button px-8">
                Confirm
            </button>
        </div>
    </form>
</x-guest-layout>
