<x-guest-layout>
    <div class="text-center mb-6">
        <div class="text-5xl mb-2">🔑</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Forgot Your Password?</h2>
        <p class="text-desert-sand/70 text-sm mt-2">No problem. We'll send you a password reset link.</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('password.email') }}">
        @csrf

        <!-- Email Address -->
        <div class="mb-6">
            <label for="email" class="block text-desert-sand font-egyptian font-semibold mb-2">Email Address</label>
            <input id="email" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300" 
                   type="email" 
                   name="email" 
                   value="{{ old('email') }}" 
                   required 
                   autofocus
                   placeholder="your.email@example.com">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <div class="flex items-center justify-between gap-4">
            <a href="{{ route('login') }}" class="text-nile-turquoise hover:text-teal-300 underline text-sm transition-colors duration-300">
                Back to login
            </a>
            <button type="submit" class="cartouche-button px-8">
                Send Reset Link
            </button>
        </div>
    </form>
</x-guest-layout>
