<x-guest-layout>
    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <div class="text-center mb-6">
        <div class="text-5xl mb-2">🏺</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Enter the Temple</h2>
        <p class="text-desert-sand/70 text-sm mt-2">Welcome back, brave seeker</p>
    </div>

    <form method="POST" action="{{ route('login') }}">
        @csrf

        <!-- Email Address -->
        <div class="mb-6">
            <label for="email" class="block text-desert-sand font-egyptian font-semibold mb-2">Email Address</label>
            <input id="email" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300" 
                   type="email" 
                   name="email" 
                   value="{{ old('email') }}" 
                   required 
                   autofocus 
                   autocomplete="username"
                   placeholder="your.email@example.com">
            @error('email')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Password -->
        <div class="mb-6">
            <label for="password" class="block text-desert-sand font-egyptian font-semibold mb-2">Password</label>
            <input id="password" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password"
                   name="password"
                   required 
                   autocomplete="current-password"
                   placeholder="••••••••">
            @error('password')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Remember Me -->
        <div class="flex items-center mb-6">
            <input id="remember_me" 
                   type="checkbox" 
                   class="rounded border-ra-gold/30 bg-papyrus-dark text-ra-gold focus:ring-ra-gold focus:ring-offset-0 cursor-pointer" 
                   name="remember">
            <label for="remember_me" class="ms-2 text-sm text-desert-sand cursor-pointer">
                Remember my journey
            </label>
        </div>

        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="flex items-center gap-3 text-sm">
                @if (Route::has('password.request'))
                    <a class="text-nile-turquoise hover:text-teal-300 underline transition-colors duration-300" href="{{ route('password.request') }}">
                        Forgot password?
                    </a>
                @endif

                @if (Route::has('register'))
                    <span class="text-desert-sand/50">•</span>
                    <a class="text-ra-gold hover:text-yellow-400 underline transition-colors duration-300 font-semibold" href="{{ route('register') }}">
                        Begin your quest
                    </a>
                @endif
            </div>

            <button type="submit" class="cartouche-button w-full sm:w-auto px-8">
                Enter Temple
            </button>
        </div>
    </form>
</x-guest-layout>
