<x-guest-layout>
    <div class="text-center mb-6">
        <div class="text-5xl mb-2">⚡</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Begin Your Quest</h2>
        <p class="text-desert-sand/70 text-sm mt-2">Join the Temple of Ra and start your sacred journey</p>
    </div>

    <form method="POST" action="{{ route('register') }}">
        @csrf

        <!-- Name -->
        <div class="mb-6">
            <label for="name" class="block text-desert-sand font-egyptian font-semibold mb-2">Your Sacred Name</label>
            <input id="name" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300" 
                   type="text" 
                   name="name" 
                   value="{{ old('name') }}" 
                   required 
                   autofocus 
                   autocomplete="name"
                   placeholder="Enter your name">
            @error('name')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Email Address -->
        <div class="mb-6">
            <label for="email" class="block text-desert-sand font-egyptian font-semibold mb-2">Email Address</label>
            <input id="email" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300" 
                   type="email" 
                   name="email" 
                   value="{{ old('email') }}" 
                   required 
                   autocomplete="username"
                   placeholder="your.email@example.com">
            @error('email')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Password -->
        <div class="mb-6">
            <label for="password" class="block text-desert-sand font-egyptian font-semibold mb-2">Create Password</label>
            <input id="password" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password"
                   name="password"
                   required 
                   autocomplete="new-password"
                   placeholder="••••••••">
            @error('password')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Confirm Password -->
        <div class="mb-6">
            <label for="password_confirmation" class="block text-desert-sand font-egyptian font-semibold mb-2">Confirm Password</label>
            <input id="password_confirmation" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password"
                   name="password_confirmation" 
                   required 
                   autocomplete="new-password"
                   placeholder="••••••••">
            @error('password_confirmation')
                <p class="mt-2 text-sm text-blood-red">{{ $message }}</p>
            @enderror
        </div>

        <!-- Benefits Info -->
        <div class="mb-6 p-4 bg-ra-gold/10 border border-ra-gold/30 rounded-lg">
            <p class="text-desert-sand text-sm mb-2 font-semibold">✨ Starting Blessings:</p>
            <ul class="text-xs text-desert-sand/80 space-y-1">
                <li>• Rank 1 - Begin your journey</li>
                <li>• 0 Divine Energy (XP) - Ready to earn</li>
                <li>• 0 Sacred Gold - Earn through quests</li>
            </ul>
        </div>

        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <a class="text-nile-turquoise hover:text-teal-300 underline text-sm transition-colors duration-300" href="{{ route('login') }}">
                Already have an account?
            </a>

            <button type="submit" class="cartouche-button w-full sm:w-auto px-8">
                Begin Quest
            </button>
        </div>
    </form>
</x-guest-layout>
