<x-guest-layout>
    <div class="text-center mb-6">
        <div class="text-5xl mb-2">🔄</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Reset Password</h2>
        <p class="text-desert-sand/70 text-sm mt-2">Create a new password for your account</p>
    </div>

    <form method="POST" action="{{ route('password.store') }}">
        @csrf

        <!-- Password Reset Token -->
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        <!-- Email Address -->
        <div class="mb-6">
            <label for="email" class="block text-desert-sand font-egyptian font-semibold mb-2">Email Address</label>
            <input id="email" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300" 
                   type="email" 
                   name="email" 
                   value="{{ old('email', $request->email) }}" 
                   required 
                   autofocus 
                   autocomplete="username"
                   placeholder="your.email@example.com">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="mb-6">
            <label for="password" class="block text-desert-sand font-egyptian font-semibold mb-2">New Password</label>
            <input id="password" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password" 
                   name="password" 
                   required 
                   autocomplete="new-password"
                   placeholder="••••••••">
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="mb-6">
            <label for="password_confirmation" class="block text-desert-sand font-egyptian font-semibold mb-2">Confirm Password</label>
            <input id="password_confirmation" 
                   class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-3 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                   type="password"
                   name="password_confirmation" 
                   required 
                   autocomplete="new-password"
                   placeholder="••••••••">
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="flex items-center justify-end">
            <button type="submit" class="cartouche-button px-8">
                Reset Password
            </button>
        </div>
    </form>
</x-guest-layout>
