<x-guest-layout>
    <div class="text-center mb-6">
        <div class="text-5xl mb-2">✉️</div>
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">Verify Your Email</h2>
    </div>

    <div class="mb-6 p-4 bg-nile-turquoise/10 border border-nile-turquoise/30 rounded-lg text-desert-sand text-sm">
        {{ __('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.') }}
    </div>

    @if (session('status') == 'verification-link-sent')
        <div class="mb-6 p-4 font-medium text-sm text-nile-turquoise bg-nile-turquoise/10 border border-nile-turquoise/30 rounded-lg">
            {{ __('A new verification link has been sent to the email address you provided during registration.') }}
        </div>
    @endif

    <div class="mt-6 flex flex-col sm:flex-row items-center justify-between gap-4">
        <form method="POST" action="{{ route('verification.send') }}">
            @csrf
            <button type="submit" class="cartouche-button px-8">
                Resend Verification Email
            </button>
        </form>

        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit" class="text-desert-sand hover:text-ra-gold underline text-sm transition-colors duration-300">
                Log Out
            </button>
        </form>
    </div>
</x-guest-layout>
