<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">📜</span>
                <span>Battle Chronicles</span>
            </h2>
            <a href="{{ route('battle.index') }}" class="cartouche-button flex items-center gap-2">
                <span>⚔️</span>
                <span>New Battle</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                @forelse($battles as $battle)
                <div class="border-b-2 border-ra-gold/30 py-4 last:border-b-0 hover:bg-papyrus-dark/30 transition-all duration-300 rounded-lg px-4">
                    <div class="flex justify-between items-center">
                        <div class="flex-1">
                            <div class="flex items-center gap-4 mb-2">
                                <span class="font-egyptian text-ra-gold text-lg">{{ $battle->enemy->name }}</span>
                                <span class="px-3 py-1 text-xs rounded-full border-2 font-semibold
                                    {{ $battle->result === 'win' ? 'bg-green-900/30 border-green-500 text-green-300' : 'bg-blood-red/30 border-blood-red text-blood-red' }}">
                                    {{ ucfirst($battle->result) }}
                                </span>
                            </div>
                            <div class="text-sm text-desert-sand flex items-center gap-3">
                                <span>📅 {{ $battle->created_at->format('M d, Y H:i') }}</span>
                                <span>•</span>
                                <span>⚔️ {{ $battle->turns_taken }} turns</span>
                                @if($battle->result === 'win')
                                <span>•</span>
                                <span class="text-nile-turquoise font-stat">✨ +{{ $battle->earned_xp }} XP</span>
                                <span>•</span>
                                <span class="text-ra-gold font-stat">💰 +{{ $battle->earned_gold }} Gold</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-12">
                    <div class="text-6xl mb-4">⚔️</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No battle chronicles yet.</p>
                    <a href="{{ route('battle.index') }}" class="cartouche-button inline-block">
                        Start Your First Battle
                    </a>
                </div>
                @endforelse

                @if($battles->hasPages())
                <div class="mt-6">
                    {{ $battles->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
