<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">⚔️</span>
                <span>Arena of Horus</span>
            </h2>
            <a href="{{ route('battle.history') }}" class="cartouche-button flex items-center gap-2">
                <span>📜</span>
                <span>Battle History</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Battle Result Modal -->
            @if(session('battle_result') && session('battle_mob_id'))
                @php
                    $battleResult = session('battle_result');
                    $mobId = session('battle_mob_id');
                    $mob = \App\Models\Mob::find($mobId);
                    // Load character relationship for user
                    $user->load('character');
                @endphp
                @if($mob)
                    <x-battle-result-modal :battleResult="$battleResult" :user="$user" :mob="$mob" />
                @endif
            @endif

            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 p-4 bg-green-900/50 border-2 border-green-500 rounded-lg text-green-300">
                    <p class="font-egyptian">{{ session('success') }}</p>
                </div>
            @endif
            
            @if(session('error'))
                <div class="mb-6 p-4 bg-red-900/50 border-2 border-red-500 rounded-lg text-red-300">
                    <p class="font-egyptian">{{ session('error') }}</p>
                </div>
            @endif
            
            @if($errors->any())
                <div class="mb-6 p-4 bg-red-900/50 border-2 border-red-500 rounded-lg">
                    <ul class="list-disc list-inside text-red-300">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <!-- User Stats -->
            <div class="quest-card mb-6">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Your Power</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <div class="text-center p-3 bg-papyrus-dark/50 border border-ra-gold/30 rounded">
                        <div class="font-stat text-2xl text-nile-turquoise">Rank {{ $user->level }}</div>
                        <div class="text-xs text-desert-sand">Level</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 border border-blood-red/30 rounded">
                        <div class="font-stat text-2xl text-blood-red">{{ $user->battles()->where('result', 'win')->count() }}</div>
                        <div class="text-xs text-desert-sand">Victories</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 border border-ra-gold/30 rounded">
                        <div class="font-stat text-2xl text-ra-gold">💰 {{ number_format($user->gold) }}</div>
                        <div class="text-xs text-desert-sand">Sacred Gold</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 border border-nile-turquoise/30 rounded">
                        <div class="font-stat text-2xl text-nile-turquoise">{{ $user->battles()->count() }}</div>
                        <div class="text-xs text-desert-sand">Total Battles</div>
                    </div>
                </div>
            </div>

            <div class="mb-6 text-center">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-2">Choose Your Ancient Foe</h3>
                <p class="text-desert-sand text-sm">Showing mobs from Rank {{ $user->level }} to Rank {{ $user->level + 2 }} (sorted by lowest power)</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($mobs as $mob)
                <div class="quest-card hover:scale-105 transition-transform duration-300 border-blood-red/30 hover:border-blood-red">
                    @if(isset($mob['sprite_source']) && $mob['sprite_source'])
                    <img src="{{ $mob['sprite_source'] }}" alt="{{ $mob['name'] }}" class="w-full h-48 object-cover rounded-lg border-2 border-blood-red mb-4">
                    @else
                    <div class="w-full h-48 bg-gradient-to-br from-blood-red/20 to-red-900/20 border-2 border-blood-red rounded-lg mb-4 flex items-center justify-center">
                        <span class="text-8xl">👹</span>
                    </div>
                    @endif

                    <div class="relative z-10">
                        <div class="flex items-center justify-between mb-2">
                            <h4 class="font-egyptian text-xl text-blood-red text-shadow-gold">{{ $mob['name'] }}</h4>
                            @if(isset($mob['rarity']))
                            <span class="px-2 py-1 text-xs rounded border
                                @if($mob['rarity'] === 'legendary') border-yellow-400 text-yellow-400
                                @elseif($mob['rarity'] === 'epic') border-purple-400 text-purple-400
                                @elseif($mob['rarity'] === 'rare') border-blue-400 text-blue-400
                                @else border-gray-400 text-gray-400
                                @endif">
                                {{ ucfirst($mob['rarity']) }}
                            </span>
                            @endif
                        </div>
                        <div class="grid grid-cols-2 gap-2 mb-4 text-sm text-desert-sand">
                            <div>
                                <span class="text-desert-sand/70">Rank:</span>
                                <span class="font-stat text-nile-turquoise ml-1">{{ $mob['level'] }}</span>
                            </div>
                            <div>
                                <span class="text-desert-sand/70">Power:</span>
                                <span class="font-stat text-ra-gold ml-1">{{ ($mob['attack'] ?? 0) + ($mob['defense'] ?? 0) + ($mob['hp'] ?? 0) }}</span>
                            </div>
                            <div>
                                <span class="text-desert-sand/70">Life:</span>
                                <span class="font-stat text-blood-red ml-1">{{ $mob['hp'] }}</span>
                            </div>
                            <div>
                                <span class="text-desert-sand/70">Strength:</span>
                                <span class="font-stat text-blood-red ml-1">{{ $mob['attack'] }}</span>
                            </div>
                            <div>
                                <span class="text-desert-sand/70">Resilience:</span>
                                <span class="font-stat text-nile-turquoise ml-1">{{ $mob['defense'] }}</span>
                            </div>
                            @if(isset($mob['speed']))
                            <div>
                                <span class="text-desert-sand/70">Speed:</span>
                                <span class="font-stat text-nile-turquoise ml-1">{{ $mob['speed'] }}</span>
                            </div>
                            @endif
                        </div>

                        <div class="mb-4 p-2 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                            <div class="flex justify-between text-xs text-desert-sand">
                                <span>Reward:</span>
                                <span class="font-stat text-nile-turquoise">✨ {{ $mob['xp_reward'] }} XP</span>
                                <span class="font-stat text-ra-gold">💰 {{ $mob['gold_reward'] }} Gold</span>
                            </div>
                        </div>

                        <form method="POST" action="{{ route('battle.start', $mob['id']) }}" 
                              onsubmit="this.querySelector('button[type=submit]').disabled=true; this.querySelector('button[type=submit]').textContent='Entering Arena...'; return true;">
                            @csrf
                            <button type="submit" class="w-full cartouche-button bg-gradient-to-r from-blood-red to-red-700 hover:from-red-700 hover:to-blood-red">
                                Enter Arena
                            </button>
                        </form>
                    </div>
                </div>
                @empty
                <div class="col-span-full quest-card text-center py-12">
                    <div class="text-6xl mb-4">⚔️</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No foes available at this time.</p>
                    <p class="text-desert-sand text-sm">Run the seeders to populate mobs: <code class="bg-papyrus-dark px-2 py-1 rounded">php artisan db:seed --class=MobSeeder</code></p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>
