<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">⚔️</span>
            <span>Battle Result</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card" 
                 x-data="{ 
                     show: true,
                     init() {
                         // Trigger win/lose animations
                         @if($battle->result === 'win' && $battle->user->character)
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: '{{ $battle->user->character->slug }}',
                                 state: 'win'
                             }
                         }));
                         @elseif(($battle->result === 'loss' || $battle->result === 'lose') && $battle->user->character)
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: '{{ $battle->user->character->slug }}',
                                 state: 'lose'
                             }
                         }));
                         @endif
                     }
                 }" 
                 x-show="show" 
                 x-transition>
                @if($battle->result === 'win')
                <!-- Victory Display with Character Animation -->
                <div class="grid grid-cols-2 gap-8 mb-6">
                    <!-- Character Win Animation -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3">{{ $battle->user->name }}</h3>
                        @if($battle->user->character)
                            <div class="w-64 h-64 mx-auto">
                                <x-character-animation 
                                    :character="$battle->user->character" 
                                    state="win" 
                                    class="w-full h-full rounded-lg border-4 border-ra-gold shadow-gold-glow"
                                    x-ref="characterWin"
                                />
                            </div>
                        @else
                            <div class="w-64 h-64 bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border-4 border-ra-gold rounded-lg flex items-center justify-center mx-auto shadow-gold-glow">
                                <span class="text-8xl">👁️</span>
                            </div>
                        @endif
                    </div>
                    
                    <!-- Enemy Lose Animation -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-blood-red mb-3">{{ $battle->enemy->name }}</h3>
                        @if($battle->enemy->image_url)
                        <img src="{{ $battle->enemy->image_url }}" 
                             alt="{{ $battle->enemy->name }}" 
                             class="w-64 h-64 object-cover rounded-lg border-4 border-blood-red mx-auto opacity-50">
                        @else
                        <div class="w-64 h-64 bg-gradient-to-br from-blood-red/10 to-red-900/10 border-4 border-blood-red rounded-lg flex items-center justify-center mx-auto opacity-50">
                            <span class="text-8xl">💀</span>
                        </div>
                        @endif
                    </div>
                </div>
                
                <div class="text-center mb-6">
                    <h2 class="font-egyptian text-4xl text-ra-gold text-shadow-gold mb-2">Victory!</h2>
                    <p class="text-desert-sand text-xl">You have vanquished {{ $battle->enemy->name }}!</p>
                    <p class="text-nile-turquoise mt-2 font-egyptian">The Eye of Ra has blessed you!</p>
                </div>

                <div class="bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border-2 border-ra-gold rounded-lg p-6 mb-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4">Divine Rewards</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                            <span class="text-desert-sand font-semibold">Divine Energy:</span>
                            <span class="font-stat text-nile-turquoise text-xl">✨ +{{ $battle->earned_xp }} XP</span>
                        </div>
                        <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                            <span class="text-desert-sand font-semibold">Sacred Gold:</span>
                            <span class="font-stat text-ra-gold text-xl">💰 +{{ $battle->earned_gold }}</span>
                        </div>
                    </div>
                </div>
                @else
                <!-- Defeat Display with Character Animation -->
                <div class="grid grid-cols-2 gap-8 mb-6">
                    <!-- Character Lose Animation -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3">{{ $battle->user->name }}</h3>
                        @if($battle->user->character)
                            <div class="w-64 h-64 mx-auto">
                                <x-character-animation 
                                    :character="$battle->user->character" 
                                    state="lose" 
                                    class="w-full h-full rounded-lg border-4 border-blood-red opacity-75"
                                    x-ref="characterLose"
                                />
                            </div>
                        @else
                            <div class="w-64 h-64 bg-gradient-to-br from-blood-red/20 to-red-900/20 border-4 border-blood-red rounded-lg flex items-center justify-center mx-auto opacity-75">
                                <span class="text-8xl">💀</span>
                            </div>
                        @endif
                    </div>
                    
                    <!-- Enemy Win Animation -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-blood-red mb-3">{{ $battle->enemy->name }}</h3>
                        @if($battle->enemy->image_url)
                        <img src="{{ $battle->enemy->image_url }}" 
                             alt="{{ $battle->enemy->name }}" 
                             class="w-64 h-64 object-cover rounded-lg border-4 border-blood-red mx-auto shadow-gold-glow">
                        @else
                        <div class="w-64 h-64 bg-gradient-to-br from-blood-red/20 to-red-900/20 border-4 border-blood-red rounded-lg flex items-center justify-center mx-auto shadow-gold-glow">
                            <span class="text-8xl">👹</span>
                        </div>
                        @endif
                    </div>
                </div>
                
                <div class="text-center mb-6">
                    <h2 class="font-egyptian text-4xl text-blood-red mb-2">Defeated!</h2>
                    <p class="text-desert-sand text-xl">You were overcome by {{ $battle->enemy->name }}.</p>
                    <p class="text-desert-sand/70 mt-2">The ancient foe has proven too powerful this time.</p>
                </div>

                <div class="bg-gradient-to-br from-blood-red/20 to-red-900/20 border-2 border-blood-red rounded-lg p-6 mb-6">
                    <p class="text-center text-desert-sand font-egyptian">Return stronger! Level up or acquire better relics from the Market of the Gods.</p>
                </div>
                @endif

                <div class="bg-papyrus-dark/50 border-2 border-ra-gold/30 rounded-lg p-4 mb-6">
                    <h4 class="font-egyptian text-ra-gold mb-3">Battle Chronicles</h4>
                    <div class="space-y-2 text-sm text-desert-sand">
                        <div class="flex justify-between">
                            <span>Ancient Foe:</span>
                            <span class="font-stat text-blood-red">{{ $battle->enemy->name }} (Rank {{ $battle->enemy->level }})</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Turns of the Duel:</span>
                            <span class="font-stat text-nile-turquoise">{{ $battle->turns_taken }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Your Life Force Remaining:</span>
                            <span class="font-stat text-nile-turquoise">{{ $battle->user_hp_remaining }}</span>
                        </div>
                    </div>
                </div>

                <div class="flex gap-4 justify-center">
                    <a href="{{ route('battle.index') }}" class="cartouche-button">
                        Battle Again
                    </a>
                    <a href="{{ route('dashboard') }}" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-6 rounded-lg transition-all duration-300">
                        Temple
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
