<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">⚔️</span>
            <span>Arena of Horus</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('info'))
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-blue-500/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand">{{ session('info') }}</span>
                </div>
            @endif

            <!-- Ancient Ruins Background Effect -->
            <div class="quest-card bg-gradient-to-br from-papyrus-dark via-shadow-ink to-papyrus-dark relative overflow-hidden">
                <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 20% 50%, rgba(212, 175, 55, 0.3) 0%, transparent 50%), radial-gradient(circle at 80% 50%, rgba(15, 185, 177, 0.3) 0%, transparent 50%);"></div>
                
                <div class="relative z-10">
                    <!-- Battle Arena - Character vs Enemy -->
                    <div class="grid grid-cols-2 gap-8 mb-8" 
                         x-data="battleAnimations({
                             characterSlug: '{{ $battle->user->character ? $battle->user->character->slug : null }}',
                             battleResult: {{ $battle->result ? "'" . $battle->result . "'" : 'null' }},
                             userHP: {{ $userHP }},
                             enemyHP: {{ $enemyHP }}
                         })"
                         x-init="init()">
                        
                        <!-- Enemy Side -->
                        <div class="text-center">
                            <div class="flex justify-center items-center gap-4 mb-4">
                                <h2 class="font-egyptian text-3xl text-blood-red text-shadow-gold">{{ $battle->enemy->name }}</h2>
                                <span class="font-stat text-nile-turquoise text-xl">Rank {{ $battle->enemy->level }}</span>
                            </div>
                            
                            <!-- Enemy Animation -->
                            <div class="w-64 h-64 mx-auto mb-4" x-ref="enemyContainer">
                                @if($battle->enemy->image_url)
                                <img src="{{ $battle->enemy->image_url }}" 
                                     alt="{{ $battle->enemy->name }}" 
                                     class="w-full h-full object-cover rounded-lg border-4 border-blood-red shadow-gold-glow"
                                     x-show="!enemyAttacking"
                                     x-transition>
                                @else
                                <div class="w-full h-full bg-gradient-to-br from-blood-red/20 to-red-900/20 border-4 border-blood-red rounded-lg flex items-center justify-center shadow-gold-glow"
                                     x-show="!enemyAttacking"
                                     x-transition>
                                    <span class="text-8xl">👹</span>
                                </div>
                                @endif
                                
                                <!-- Enemy Attack Animation -->
                                <div x-show="enemyAttacking" 
                                     x-transition
                                     class="w-full h-full bg-gradient-to-br from-blood-red/40 to-red-900/40 border-4 border-blood-red rounded-lg flex items-center justify-center shadow-gold-glow animate-pulse">
                                    <span class="text-8xl">⚔️</span>
                                </div>
                            </div>

                            <!-- User HP -->
                            <div class="mb-4">
                                <div class="flex justify-between text-sm mb-2 text-desert-sand">
                                    <span>Your Life Force</span>
                                    <span class="font-stat text-nile-turquoise" x-text="userHP + ' / {{ $userMaxHP }}'"></span>
                                </div>
                                <div class="relative w-full bg-shadow-ink rounded-full h-8 border-2 border-nile-turquoise overflow-hidden">
                                    <div class="h-8 rounded-full transition-all duration-500 flex items-center justify-center bg-gradient-to-r from-nile-turquoise to-teal-400 shadow-turquoise-glow" 
                                         :style="'width: ' + Math.max(0, Math.min(100, (userHP / {{ $userMaxHP }}) * 100)) + '%'">
                                        <span x-show="(userHP / {{ $userMaxHP }}) * 100 > 15" 
                                              class="text-xs font-stat text-papyrus-dark font-bold"
                                              x-text="Math.round((userHP / {{ $userMaxHP }}) * 100) + '%'"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                            <!-- Enemy HP -->
                            <div class="mb-4">
                                <div class="flex justify-between text-sm mb-2 text-desert-sand">
                                    <span>Ancient Foe's Life Force</span>
                                    <span class="font-stat text-blood-red" x-text="enemyHP + ' / {{ $enemyMaxHP }}'"></span>
                                </div>
                                <div class="relative w-full bg-shadow-ink rounded-full h-8 border-2 border-blood-red overflow-hidden">
                                    <div class="energy-orb h-8 rounded-full transition-all duration-500 flex items-center justify-center" 
                                         :style="'width: ' + Math.max(0, Math.min(100, (enemyHP / {{ $enemyMaxHP }}) * 100)) + '%'">
                                        <span x-show="(enemyHP / {{ $enemyMaxHP }}) * 100 > 15" 
                                              class="text-xs font-stat text-papyrus-dark font-bold"
                                              x-text="Math.round((enemyHP / {{ $enemyMaxHP }}) * 100) + '%'"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Character Side -->
                        <div class="text-center">
                            <div class="flex justify-center items-center gap-4 mb-4">
                                <h2 class="font-egyptian text-3xl text-nile-turquoise text-shadow-turquoise">{{ $battle->user->name }}</h2>
                                <span class="font-stat text-ra-gold text-xl">Rank {{ $battle->user->level }}</span>
                            </div>
                            
                            <!-- Character Animation -->
                            <div class="w-64 h-64 mx-auto mb-4" x-ref="characterContainer">
                                @if($battle->user->character)
                                    <x-character-animation 
                                        :character="$battle->user->character" 
                                        state="idle" 
                                        class="w-full h-full rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow"
                                        x-ref="characterAnimation"
                                    />
                                @else
                                    <div class="w-full h-full bg-gradient-to-br from-nile-turquoise/20 to-teal-400/20 border-4 border-nile-turquoise rounded-lg flex items-center justify-center shadow-turquoise-glow">
                                        <span class="text-8xl">👤</span>
                                    </div>
                                @endif
                            </div>


                        <!-- User Stats - Egyptian Terms -->
                        <div class="grid grid-cols-4 gap-2 mt-4 text-sm">
                            <div class="text-center p-2 bg-blood-red/10 border border-blood-red/30 rounded">
                                <div class="font-stat text-blood-red text-lg">{{ $userStats['attack'] }}</div>
                                <div class="text-desert-sand text-xs">Strength</div>
                            </div>
                            <div class="text-center p-2 bg-nile-turquoise/10 border border-nile-turquoise/30 rounded">
                                <div class="font-stat text-nile-turquoise text-lg">{{ $userStats['defense'] }}</div>
                                <div class="text-desert-sand text-xs">Resilience</div>
                            </div>
                            <div class="text-center p-2 bg-purple-500/10 border border-purple-400/30 rounded">
                                <div class="font-stat text-purple-300 text-lg">{{ $userStats['magic'] }}</div>
                                <div class="text-desert-sand text-xs">Wisdom</div>
                            </div>
                            <div class="text-center p-2 bg-pink-500/10 border border-pink-400/30 rounded">
                                <div class="font-stat text-pink-300 text-lg">{{ $userStats['stamina'] }}</div>
                                <div class="text-desert-sand text-xs">Endurance</div>
                            </div>
                        </div>
                    </div>

                    <!-- Battle Info -->
                    <div class="bg-papyrus-dark/50 border border-ra-gold/30 p-4 rounded-lg mb-6 text-center">
                        <p class="text-desert-sand font-egyptian">Turn {{ $battle->turns_taken + 1 }} of the Duel</p>
                    </div>
                    
                    @push('scripts')
                    <script>
                    document.addEventListener('alpine:init', () => {
                        Alpine.data('battleAnimations', (config) => ({
                            characterSlug: config.characterSlug,
                            battleResult: config.battleResult,
                            userHP: config.userHP,
                            enemyHP: config.enemyHP,
                            attacking: false,
                            enemyAttacking: false,
                            
                            init() {
                                // If battle is over, show win/lose animations
                                if (this.battleResult) {
                                    this.showBattleResult();
                                }
                            },
                            
                            handleAttack(event) {
                                this.attacking = true;
                                
                                // Play character attack animation
                                if (this.characterSlug) {
                                    window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                                        detail: {
                                            characterSlug: this.characterSlug,
                                            state: 'attack'
                                        }
                                    }));
                                }
                                
                                // Show enemy attack animation after a delay
                                setTimeout(() => {
                                    this.enemyAttacking = true;
                                }, 300);
                                
                                // Submit form after animation
                                setTimeout(() => {
                                    event.target.closest('form').submit();
                                }, 800);
                            },
                            
                            showBattleResult() {
                                if (this.battleResult === 'win' && this.characterSlug) {
                                    // Play win animation
                                    window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                                        detail: {
                                            characterSlug: this.characterSlug,
                                            state: 'win'
                                        }
                                    }));
                                } else if (this.battleResult === 'loss' && this.characterSlug) {
                                    // Play lose animation
                                    window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                                        detail: {
                                            characterSlug: this.characterSlug,
                                            state: 'lose'
                                        }
                                    }));
                                }
                            }
                        }));
                    });
                    </script>
                    @endpush

                    <!-- Attack Button - Sun Fire Beam -->
                    @if($battle->result === null && $userHP > 0 && $enemyHP > 0)
                    <form method="POST" action="{{ route('battle.attack', $battle) }}" class="text-center" 
                          @submit.prevent="handleAttack($event)">
                        @csrf
                        <button type="submit" 
                                class="cartouche-button text-xl py-4 px-12 bg-gradient-to-r from-ra-gold to-yellow-500 hover:from-yellow-500 hover:to-ra-gold shadow-gold-glow-lg transform hover:scale-110 transition-all duration-300"
                                :disabled="attacking"
                                :class="{ 'animate-gold-pulse': attacking }">
                            <span class="inline-block">☀️</span>
                            <span class="ml-2">Strike with Sun Fire!</span>
                        </button>
                    </form>
                    @endif

                    @if($battle->result !== null)
                    <div class="text-center">
                        <a href="{{ route('battle.index') }}" class="cartouche-button inline-block">
                            Return to Arena
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
