<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">📜</span>
            <span>Create New Scroll</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="{{ route('categories.store') }}">
                    @csrf

                    <div class="mb-6">
                        <label for="name" class="block text-desert-sand font-egyptian font-semibold mb-2">Scroll Name</label>
                        <input id="name" name="name" type="text" value="{{ old('name') }}" required autofocus
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                        @error('name')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="repeat_type" class="block text-desert-sand font-egyptian font-semibold mb-2">Repeat Type</label>
                        <select id="repeat_type" name="repeat_type" required
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                            <option value="one-time" {{ old('repeat_type', 'one-time') == 'one-time' ? 'selected' : '' }}>One-time Scroll</option>
                            <option value="daily" {{ old('repeat_type') == 'daily' ? 'selected' : '' }}>Daily Scroll</option>
                            <option value="weekly" {{ old('repeat_type') == 'weekly' ? 'selected' : '' }}>Weekly Scroll</option>
                            <option value="monthly" {{ old('repeat_type') == 'monthly' ? 'selected' : '' }}>Monthly Scroll</option>
                            <option value="yearly" {{ old('repeat_type') == 'yearly' ? 'selected' : '' }}>Yearly Scroll</option>
                        </select>
                        @error('repeat_type')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="color" class="block text-desert-sand font-egyptian font-semibold mb-2">Color</label>
                        <div class="flex gap-3 items-center">
                            <input id="color" name="color" type="color" value="{{ old('color', '#d4af37') }}"
                                class="block w-20 h-12 rounded-lg border-2 border-ra-gold/30 cursor-pointer bg-papyrus-dark"
                                style="appearance: none; -webkit-appearance: none;">
                            <input type="text" 
                                   id="color-text" 
                                   value="{{ old('color', '#d4af37') }}"
                                   readonly
                                   class="flex-1 bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300 font-stat">
                        </div>
                        <p class="mt-2 text-xs text-desert-sand/70">Choose a color for your scroll</p>
                        @error('color')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="icon" class="block text-desert-sand font-egyptian font-semibold mb-2">Icon</label>
                        <select id="icon" name="icon"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300 text-2xl"
                            style="font-size: 1.5rem; line-height: 2rem;">
                            <option value="">Select an Icon</option>
                            <option value="📜" {{ old('icon') == '📜' ? 'selected' : '' }}>📜 Scroll</option>
                            <option value="🗺️" {{ old('icon') == '🗺️' ? 'selected' : '' }}>🗺️ Map</option>
                            <option value="🏺" {{ old('icon') == '🏺' ? 'selected' : '' }}>🏺 Vase</option>
                            <option value="👁️" {{ old('icon') == '👁️' ? 'selected' : '' }}>👁️ Eye of Ra</option>
                            <option value="⚔️" {{ old('icon') == '⚔️' ? 'selected' : '' }}>⚔️ Swords</option>
                            <option value="🛡️" {{ old('icon') == '🛡️' ? 'selected' : '' }}>🛡️ Shield</option>
                            <option value="💰" {{ old('icon') == '💰' ? 'selected' : '' }}>💰 Gold</option>
                            <option value="🧿" {{ old('icon') == '🧿' ? 'selected' : '' }}>🧿 Amulet</option>
                            <option value="🔮" {{ old('icon') == '🔮' ? 'selected' : '' }}>🔮 Crystal Ball</option>
                            <option value="⚡" {{ old('icon') == '⚡' ? 'selected' : '' }}>⚡ Lightning</option>
                            <option value="🔥" {{ old('icon') == '🔥' ? 'selected' : '' }}>🔥 Fire</option>
                            <option value="💎" {{ old('icon') == '💎' ? 'selected' : '' }}>💎 Gem</option>
                            <option value="🌟" {{ old('icon') == '🌟' ? 'selected' : '' }}>🌟 Star</option>
                            <option value="🌙" {{ old('icon') == '🌙' ? 'selected' : '' }}>🌙 Moon</option>
                            <option value="☀️" {{ old('icon') == '☀️' ? 'selected' : '' }}>☀️ Sun</option>
                            <option value="🎯" {{ old('icon') == '🎯' ? 'selected' : '' }}>🎯 Target</option>
                            <option value="🏆" {{ old('icon') == '🏆' ? 'selected' : '' }}>🏆 Trophy</option>
                            <option value="👑" {{ old('icon') == '👑' ? 'selected' : '' }}>👑 Crown</option>
                            <option value="📿" {{ old('icon') == '📿' ? 'selected' : '' }}>📿 Prayer Beads</option>
                            <option value="🔔" {{ old('icon') == '🔔' ? 'selected' : '' }}>🔔 Bell</option>
                            <option value="🎪" {{ old('icon') == '🎪' ? 'selected' : '' }}>🎪 Tent</option>
                            <option value="🗡️" {{ old('icon') == '🗡️' ? 'selected' : '' }}>🗡️ Dagger</option>
                            <option value="🏹" {{ old('icon') == '🏹' ? 'selected' : '' }}>🏹 Bow</option>
                            <option value="🪶" {{ old('icon') == '🪶' ? 'selected' : '' }}>🪶 Feather</option>
                            <option value="🐍" {{ old('icon') == '🐍' ? 'selected' : '' }}>🐍 Snake</option>
                            <option value="🦅" {{ old('icon') == '🦅' ? 'selected' : '' }}>🦅 Eagle</option>
                            <option value="🐺" {{ old('icon') == '🐺' ? 'selected' : '' }}>🐺 Wolf</option>
                        </select>
                        <p class="mt-2 text-xs text-desert-sand/70">Choose an icon to represent your scroll</p>
                        @error('icon')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('categories.index') }}" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-6 rounded-lg transition-all duration-300">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button">
                            Create Scroll
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Sync color picker with text input
        document.getElementById('color').addEventListener('input', function(e) {
            document.getElementById('color-text').value = e.target.value.toUpperCase();
        });
        
        document.getElementById('color-text').addEventListener('input', function(e) {
            if (/^#[0-9A-F]{6}$/i.test(e.target.value)) {
                document.getElementById('color').value = e.target.value;
            }
        });
    </script>
</x-app-layout>
