<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">📜</span>
                <span>Quest Scrolls</span>
            </h2>
            <a href="{{ route('categories.create') }}" class="cartouche-button flex items-center gap-2">
                <span>📜</span>
                <span>New Scroll</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($categories as $category)
                <div class="quest-card hover:scale-105 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold">{{ $category->name }}</h3>
                            <span class="text-sm text-desert-sand capitalize mt-1 block">
                                @if($category->repeat_type === 'one-time' || $category->repeat_type === 'once')
                                    One-Time Scroll
                                @elseif($category->repeat_type === 'daily')
                                    Daily Scroll
                                @elseif($category->repeat_type === 'weekly')
                                    Weekly Scroll
                                @elseif($category->repeat_type === 'monthly')
                                    Monthly Scroll
                                @elseif($category->repeat_type === 'yearly')
                                    Yearly Scroll
                                @else
                                    {{ ucfirst($category->repeat_type) }} Scroll
                                @endif
                            </span>
                        </div>
                        @if($category->icon)
                        <span class="text-4xl">{{ $category->icon }}</span>
                        @endif
                    </div>

                    <div class="flex justify-between items-center mb-4 p-2 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <span class="text-desert-sand text-sm">{{ $category->tasks()->count() }} quests</span>
                        @if($category->color)
                        <div class="w-6 h-6 rounded-full border-2 border-ra-gold" style="background-color: {{ $category->color }}"></div>
                        @endif
                    </div>

                    <div class="flex gap-2">
                        <a href="{{ route('categories.show', $category) }}" class="flex-1 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                            View
                        </a>
                        <a href="{{ route('categories.edit', $category) }}" class="flex-1 bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold text-ra-gold text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                            Edit
                        </a>
                        <form method="POST" action="{{ route('categories.destroy', $category) }}" class="flex-1" 
                            onsubmit="return confirm('Delete this scroll? All quests will be deleted too.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-full bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red text-blood-red text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                                Delete
                            </button>
                        </form>
                    </div>
                </div>
                @empty
                <div class="col-span-full quest-card text-center py-12">
                    <div class="text-6xl mb-4">📜</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No scrolls found.</p>
                    <a href="{{ route('categories.create') }}" class="cartouche-button inline-block">
                        Create Your First Scroll!
                    </a>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>
