@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    @push('head')
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@400;700&family=Noto+Serif:wght@400;600;700&family=Orbitron:wght@400;600;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('arean 3/index.css') }}">
        <style>
            #arena3-container {
                position: relative;
                width: 100%;
                height: calc(100vh - 200px);
                min-height: 500px;
                overflow: visible;
            }
            #topBar {
                width: 100%;
                height: 100%;
            }
            canvas {
                display: block;
            }
            .state-header {
                background: rgba(0, 0, 0, 0.8);
                border-bottom: 4px solid #818cf8;
                padding: 12px 20px;
                display: flex;
                justify-content: space-between;
                align-items: center;
                font-family: 'Cinzel Decorative', 'Noto Serif', serif;
                font-size: 10px;
                color: white;
                position: relative;
                z-index: 1000;
            }
            .state-item {
                display: flex;
                flex-direction: column;
                align-items: center;
                gap: 5px;
            }
            .state-label {
                color: #818cf8;
                font-size: 8px;
            }
            .state-value {
                color: white;
                font-size: 12px;
                text-transform: uppercase;
                padding: 4px 12px;
                background: rgba(129, 140, 248, 0.2);
                border: 2px solid #818cf8;
                border-radius: 4px;
            }
            .character-name {
                color: #60a5fa;
            }
            .mob-name {
                color: #f87171;
            }
            .finishMoveMeterSmall {
                margin-top: 8px;
                width: 100%;
                display: flex;
                justify-content: center;
            }
            .finishMoveBarSmall {
                position: relative;
                width: 120px;
                height: 12px;
                border: 2px solid white;
                background-color: #1f2937;
            }
            .finishMoveBackgroundSmall {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: linear-gradient(90deg, #1f2937 0%, #374151 50%, #1f2937 100%);
            }
            .finishMoveFillSmall {
                position: absolute;
                top: 0;
                left: 0;
                height: 100%;
                width: 0%;
                background: linear-gradient(90deg, #fbbf24 0%, #f59e0b 50%, #d97706 100%);
                transition: width 0.3s ease;
                box-shadow: 0 0 5px rgba(251, 191, 36, 0.5);
            }
            .finishMoveFillSmall.full {
                background: linear-gradient(90deg, #ef4444 0%, #dc2626 50%, #b91c1c 100%);
                box-shadow: 0 0 10px rgba(239, 68, 68, 0.8);
                animation: finishMovePulseSmall 0.5s infinite;
            }
            @keyframes finishMovePulseSmall {
                0%, 100% { opacity: 1; }
                50% { opacity: 0.8; }
            }
            
            /* Slash/Impact Effect */
            .slash-effect {
                position: absolute;
                width: 200px;
                height: 4px;
                background: linear-gradient(90deg, 
                    transparent 0%,
                    rgba(255, 255, 255, 0.9) 20%,
                    rgba(255, 193, 7, 0.9) 50%,
                    rgba(255, 255, 255, 0.9) 80%,
                    transparent 100%
                );
                box-shadow: 
                    0 0 20px rgba(255, 255, 255, 0.8),
                    0 0 40px rgba(255, 193, 7, 0.6),
                    0 0 60px rgba(255, 0, 0, 0.4);
                pointer-events: none;
                z-index: 100;
                transform-origin: left center;
                animation: slashAnimation 0.4s ease-out forwards;
            }

            .slash-effect.critical {
                width: 300px;
                height: 6px;
                background: linear-gradient(90deg, 
                    transparent 0%,
                    rgba(255, 215, 0, 1) 20%,
                    rgba(255, 255, 255, 1) 50%,
                    rgba(255, 215, 0, 1) 80%,
                    transparent 100%
                );
                box-shadow: 
                    0 0 30px rgba(255, 215, 0, 1),
                    0 0 60px rgba(255, 215, 0, 0.8),
                    0 0 90px rgba(255, 0, 0, 0.6);
            }

            @keyframes slashAnimation {
                0% { 
                    opacity: 0;
                    transform: scaleX(0) rotate(0deg);
                }
                30% { 
                    opacity: 1;
                    transform: scaleX(1) rotate(-15deg);
                }
                70% { 
                    opacity: 1;
                    transform: scaleX(1) rotate(15deg);
                }
                100% { 
                    opacity: 0;
                    transform: scaleX(0.5) rotate(30deg);
                }
            }
            
            /* Energy wave at impact point */
            .energy-wave {
                position: absolute;
                width: 60px;
                height: 60px;
                border: 3px solid rgba(255, 193, 7, 0.8);
                border-radius: 50%;
                pointer-events: none;
                z-index: 99;
                animation: energyWave 0.5s ease-out forwards;
            }

            @keyframes energyWave {
                0% { 
                    transform: translate(-50%, -50%) scale(0);
                    opacity: 1;
                }
                100% { 
                    transform: translate(-50%, -50%) scale(3);
                    opacity: 0;
                }
            }
            
            /* Impact sparks */
            .impact-sparks {
                position: absolute;
                pointer-events: none;
                z-index: 98;
            }

            .spark {
                position: absolute;
                width: 4px;
                height: 4px;
                background: rgba(255, 255, 255, 0.9);
                border-radius: 50%;
                box-shadow: 0 0 10px rgba(255, 193, 7, 0.8);
                animation: sparkAnimation 0.6s ease-out forwards;
            }

            @keyframes sparkAnimation {
                0% { 
                    transform: translate(0, 0) scale(1);
                    opacity: 1;
                }
                100% { 
                    transform: translate(var(--spark-x), var(--spark-y)) scale(0);
                    opacity: 0;
                }
            }
            #roundDisplay {
                background-color: #818cf8;
                width: 150px;
                height: 50px;
                flex-shrink: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                border: 4px solid white;
                font-size: 12px;
                margin: 0 10px;
                font-family: 'Orbitron', sans-serif;
            }
            #finishMoveMeterContainer {
                display: flex;
                flex-direction: column;
                align-items: center;
                gap: 5px;
                margin: 0 10px;
            }
            .finishMoveLabel {
                font-family: 'Cinzel Decorative', 'Noto Serif', serif;
                font-size: 8px;
                color: #fbbf24;
                text-shadow: 2px 2px 0px #000;
            }
            .finishMoveBar {
                position: relative;
                width: 120px;
                height: 20px;
                border: 3px solid white;
                background-color: #1f2937;
            }
            .finishMoveBackground {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: linear-gradient(90deg, #1f2937 0%, #374151 50%, #1f2937 100%);
            }
            #finishMoveFill {
                position: absolute;
                top: 0;
                left: 0;
                height: 100%;
                width: 0%;
                background: linear-gradient(90deg, #fbbf24 0%, #f59e0b 50%, #d97706 100%);
                transition: width 0.3s ease;
                box-shadow: 0 0 10px rgba(251, 191, 36, 0.5);
            }
            #finishMoveFill.full {
                background: linear-gradient(90deg, #ef4444 0%, #dc2626 50%, #b91c1c 100%);
                box-shadow: 0 0 20px rgba(239, 68, 68, 0.8);
                animation: finishMovePulse 0.5s infinite;
            }
            @keyframes finishMovePulse {
                0%, 100% { opacity: 1; }
                50% { opacity: 0.8; }
            }
            
            /* Fight Log Styles (Arena 1 Style) */
            #fightLog {
                font-family: 'Courier New', monospace;
            }
            
            #fightLog .log-entry {
                animation: logEntryFadeIn 0.3s ease-in;
            }
            
            @keyframes logEntryFadeIn {
                from {
                    opacity: 0;
                    transform: translateX(-10px);
                }
                to {
                    opacity: 1;
                    transform: translateX(0);
                }
            }
            
            /* Countdown Animation */
            @keyframes countdownPulse {
                0% {
                    transform: scale(1);
                    opacity: 1;
                }
                50% {
                    transform: scale(1.2);
                    opacity: 0.8;
                }
                100% {
                    transform: scale(1);
                    opacity: 1;
                }
            }
            .countdown-number {
                animation: countdownPulse 1s ease-in-out;
                text-shadow: 0 0 20px rgba(212, 175, 55, 0.8), 0 0 40px rgba(212, 175, 55, 0.6);
            }
        </style>
    @endpush
    
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">⚔️</span>
                <span>Arena 3</span>
            </h2>
            @if(!isset($showSelection) || !$showSelection)
                <a href="{{ route('characters.arena-3') }}" class="cartouche-button text-sm">
                    ← Change Selection
                </a>
            @endif
        </div>
    </x-slot>

    <div class="py-4">
        <div class="max-w-7xl mx-auto">
            @if(isset($showSelection) && $showSelection)
                <!-- Character and Mob Selection -->
                <div class="quest-card mb-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4">Select Your Fighter</h3>
                    
                    @if(isset($error))
                        <div class="mb-4 p-4 bg-red-900/50 border-2 border-red-500 rounded-lg text-red-300">
                            <p class="font-egyptian">{{ $error }}</p>
                        </div>
                    @endif
                    
                    @if($characters->isEmpty() || $mobs->isEmpty())
                        <div class="bg-papyrus-dark/50 border-2 border-ra-gold/30 rounded-lg p-6 text-center">
                            <p class="text-desert-sand mb-2">
                                @if($characters->isEmpty() && $mobs->isEmpty())
                                    <strong class="text-ra-gold">No characters or mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character and one mob.</span>
                                @elseif($characters->isEmpty())
                                    <strong class="text-nile-turquoise">No characters with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character.</span>
                                @else
                                    <strong class="text-blood-red">No mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one mob.</span>
                                @endif
                            </p>
                        </div>
                    @else
                        @php
                            // Pre-encode character and mob data for JavaScript
                            $charactersData = [];
                            foreach ($characters as $char) {
                                $charactersData[$char->slug] = [
                                    'slug' => $char->slug,
                                    'name' => $char->name,
                                    'image_normal' => $char->image_normal ? Storage::url($char->image_normal) : null,
                                    'image_idle' => $char->image_idle ? Storage::url($char->image_idle) : null,
                                ];
                            }
                            $mobsData = [];
                            foreach ($mobs as $mobItem) {
                                $mobsData[$mobItem->slug] = [
                                    'slug' => $mobItem->slug,
                                    'name' => $mobItem->name,
                                    'image_normal' => $mobItem->image_normal ? Storage::url($mobItem->image_normal) : null,
                                ];
                            }
                            // Pre-encode background data
                            $backgroundsData = [];
                            foreach ($allBackgrounds as $bg) {
                                $backgroundsData[$bg->id] = [
                                    'id' => $bg->id,
                                    'name' => $bg->name,
                                    'image_path' => $bg->image_path ? Storage::url($bg->image_path) : null,
                                ];
                            }
                            // Add default background
                            $defaultBgPath = asset('arean 3/backgrounds/Background1.png');
                            $backgroundsData['default'] = [
                                'id' => 'default',
                                'name' => 'Default Background',
                                'image_path' => $defaultBgPath,
                            ];
                        @endphp
                        
                        <div 
                            data-characters='@json($charactersData)'
                            data-mobs='@json($mobsData)'
                            data-backgrounds='@json($backgroundsData)'
                            x-data="{
                                selectedCharacterSlug: '',
                                selectedMobSlug: '',
                                selectedBackgroundId: '{{ $selectedBackground ? $selectedBackground->id : 'default' }}',
                                charactersData: JSON.parse($el.dataset.characters || '{}'),
                                mobsData: JSON.parse($el.dataset.mobs || '{}'),
                                backgroundsData: JSON.parse($el.dataset.backgrounds || '{}'),
                                countdown: 0,
                                countdownInterval: null,
                                getSelectedCharacter() {
                                    if (!this.selectedCharacterSlug) return null;
                                    return this.charactersData[this.selectedCharacterSlug] || null;
                                },
                                getSelectedMob() {
                                    if (!this.selectedMobSlug) return null;
                                    return this.mobsData[this.selectedMobSlug] || null;
                                },
                                getSelectedBackground() {
                                    if (!this.selectedBackgroundId || this.selectedBackgroundId === '') {
                                        return this.backgroundsData['default'] || null;
                                    }
                                    return this.backgroundsData[this.selectedBackgroundId] || this.backgroundsData['default'] || null;
                                },
                                startCountdown() {
                                    if (this.countdownInterval) {
                                        clearInterval(this.countdownInterval);
                                    }
                                    this.countdown = 3;
                                    this.countdownInterval = setInterval(() => {
                                        this.countdown--;
                                        if (this.countdown <= 0) {
                                            clearInterval(this.countdownInterval);
                                            this.countdownInterval = null;
                                            // Build URL with parameters
                                            let url = '{{ route("characters.arena-3") }}?character=' + this.selectedCharacterSlug + '&mob=' + this.selectedMobSlug;
                                            if (this.selectedBackgroundId && this.selectedBackgroundId !== '' && this.selectedBackgroundId !== 'default') {
                                                url += '&background=' + this.selectedBackgroundId;
                                            }
                                            // Redirect to arena
                                            window.location.href = url;
                                        }
                                    }, 1000);
                                },
                                cancelCountdown() {
                                    if (this.countdownInterval) {
                                        clearInterval(this.countdownInterval);
                                        this.countdownInterval = null;
                                    }
                                    this.countdown = 0;
                                },
                                init() {
                                    // Watch for when both character and mob are selected
                                    this.$watch('selectedCharacterSlug', () => {
                                        this.checkAndStartCountdown();
                                    });
                                    this.$watch('selectedMobSlug', () => {
                                        this.checkAndStartCountdown();
                                    });
                                },
                                checkAndStartCountdown() {
                                    // Only start countdown if both are selected and countdown is not already running
                                    if (this.selectedCharacterSlug && this.selectedMobSlug && this.countdown === 0) {
                                        // Small delay to ensure UI is updated
                                        setTimeout(() => {
                                            if (this.selectedCharacterSlug && this.selectedMobSlug && this.countdown === 0) {
                                                this.startCountdown();
                                            }
                                        }, 100);
                                    } else if (!this.selectedCharacterSlug || !this.selectedMobSlug) {
                                        // Cancel countdown if either is deselected
                                        this.cancelCountdown();
                                    }
                                }
                            }"
                            class="space-y-6">
                            
                            <!-- Countdown Overlay -->
                            <div 
                                x-show="countdown > 0" 
                                x-cloak
                                class="fixed inset-0 bg-shadow-ink/90 z-50 flex items-center justify-center"
                                style="display: none;"
                                x-transition:enter="transition-opacity ease-out duration-300"
                                x-transition:enter-start="opacity-0"
                                x-transition:enter-end="opacity-100">
                                <div class="text-center">
                                    <div class="countdown-number text-9xl font-egyptian text-ra-gold mb-4" x-text="countdown"></div>
                                    <p class="text-desert-sand text-xl mb-4 font-egyptian">Entering Arena...</p>
                                    <button 
                                        type="button"
                                        @click="cancelCountdown()"
                                        class="px-6 py-2 bg-blood-red/80 hover:bg-blood-red border-2 border-blood-red rounded-lg text-desert-sand font-semibold transition-all">
                                        Cancel
                                    </button>
                                </div>
                            </div>
                            
                            <form method="GET" action="{{ route('characters.arena-3') }}" x-ref="arenaForm" class="space-y-6">
                                <div class="grid grid-cols-2 gap-6 mb-6">
                                    <!-- Character Selection -->
                                    <div>
                                        <label class="block text-desert-sand font-semibold mb-2">Character:</label>
                                        <select 
                                            name="character"
                                            x-model="selectedCharacterSlug"
                                            required
                                            class="w-full bg-papyrus-dark border border-ra-gold/30 rounded-lg px-4 py-2 text-desert-sand">
                                            <option value="">Select Character...</option>
                                            @foreach($characters as $char)
                                                <option value="{{ $char->slug }}">{{ $char->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <!-- Mob Selection -->
                                    <div>
                                        <label class="block text-desert-sand font-semibold mb-2">Mob:</label>
                                        <select 
                                            name="mob"
                                            x-model="selectedMobSlug"
                                            required
                                            class="w-full bg-papyrus-dark border border-blood-red/30 rounded-lg px-4 py-2 text-desert-sand">
                                            <option value="">Select Mob...</option>
                                            @foreach($mobs as $mobItem)
                                                <option value="{{ $mobItem->slug }}">{{ $mobItem->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <!-- Animation Display -->
                                <div class="grid grid-cols-2 gap-8 mb-6">
                                    <!-- Character Side (Right Facing) -->
                                    <div class="text-center">
                                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3" 
                                            x-text="getSelectedCharacter() ? getSelectedCharacter().name : 'No Character Selected'"></h3>
                                        <div class="w-full max-w-md mx-auto">
                                            @foreach($characters as $char)
                                                <div x-show="selectedCharacterSlug === '{{ $char->slug }}'" style="display: none;">
                                                    <x-character-animation 
                                                        :character="$char"
                                                        state="idle"
                                                        direction="right"
                                                        class="w-full rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow"
                                                        :autoplay="true"
                                                    />
                                                </div>
                                            @endforeach
                                            <div x-show="!selectedCharacterSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-nile-turquoise/30">
                                                <span class="text-desert-sand/50">Select a character</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Mob Side (Left Facing) -->
                                    <div class="text-center">
                                        <h3 class="font-egyptian text-xl text-blood-red mb-3" 
                                            x-text="getSelectedMob() ? getSelectedMob().name : 'No Mob Selected'"></h3>
                                        <div class="w-full max-w-md mx-auto">
                                            @foreach($mobs as $mobItem)
                                                <div x-show="selectedMobSlug === '{{ $mobItem->slug }}'" style="display: none;">
                                                    <x-mob-animation 
                                                        :mob="$mobItem"
                                                        state="idle"
                                                        direction="left"
                                                        class="w-full rounded-lg border-4 border-blood-red shadow-gold-glow"
                                                        :autoplay="true"
                                                    />
                                                </div>
                                            @endforeach
                                            <div x-show="!selectedMobSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-blood-red/30">
                                                <span class="text-desert-sand/50">Select a mob</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            
                            <!-- Background Selection -->
                            <div>
                                <label class="block text-desert-sand font-semibold mb-2">Arena Background:</label>
                                <select 
                                    name="background"
                                    x-model="selectedBackgroundId"
                                    class="w-full bg-papyrus-dark border border-nile-turquoise/30 rounded-lg px-4 py-2 text-desert-sand">
                                    <option value="">Use Default Background</option>
                                    @foreach($allBackgrounds as $bg)
                                        @if(in_array($bg->id, $ownedBackgroundIds))
                                            <option value="{{ $bg->id }}" {{ $selectedBackground && $selectedBackground->id == $bg->id ? 'selected' : '' }}>
                                                {{ $bg->name }} ✓
                                            </option>
                                        @else
                                            <option value="{{ $bg->id }}" disabled>
                                                {{ $bg->name }} 🔒 (Locked)
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                                <p class="text-sm text-desert-sand/70 mt-1">Select a background for the arena. Locked backgrounds are not available.</p>
                                
                                <!-- Background Preview -->
                                <div class="mt-4">
                                    <div class="text-center">
                                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3" 
                                            x-text="getSelectedBackground() ? getSelectedBackground().name : 'Default Background'"></h3>
                                        <div class="w-full max-w-2xl mx-auto">
                                            <div class="w-full h-48 rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow overflow-hidden bg-shadow-ink/30 relative">
                                                <img 
                                                    x-show="getSelectedBackground() && getSelectedBackground().image_path"
                                                    :src="getSelectedBackground() ? getSelectedBackground().image_path : ''" 
                                                    :alt="getSelectedBackground() ? getSelectedBackground().name : 'Default Background'"
                                                    class="w-full h-full object-cover absolute inset-0"
                                                    style="display: none;"
                                                />
                                                <div x-show="!getSelectedBackground() || !getSelectedBackground().image_path" class="w-full h-full bg-papyrus-dark/50 flex items-center justify-center absolute inset-0">
                                                    <span class="text-desert-sand/50">Default Background</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                                <!-- Start Fight Button (Optional - countdown will auto-start) -->
                                <div class="text-center" x-show="selectedCharacterSlug && selectedMobSlug && countdown === 0">
                                    <button 
                                        type="button"
                                        @click="startCountdown()"
                                        class="inline-block px-8 py-3 bg-blood-red text-shadow-ink font-egyptian text-lg rounded-lg hover:bg-blood-red/80 transition-all border-2 border-blood-red/50 shadow-lg">
                                        ⚔️ Start Battle ⚔️
                                    </button>
                                    <p class="text-sm text-desert-sand/70 mt-2">Or wait for automatic countdown...</p>
                                </div>
                            </form>
                        </div>
                    @endif
                </div>
            @else
                <!-- State Header -->
                <div class="state-header" id="stateHeader">
                    <div class="state-item">
                        <div class="state-label">CHARACTER</div>
                        <div class="character-name" id="characterName">{{ $character->name }}</div>
                        <div class="state-value" id="characterState">IDLE</div>
                    <!-- Player Finish Move Meter -->
                    <div class="finishMoveMeterSmall">
                        <div class="finishMoveBarSmall">
                            <div class="finishMoveBackgroundSmall"></div>
                            <div id="playerFinishMoveFill" class="finishMoveFillSmall"></div>
                        </div>
                    </div>
                </div>
                <div class="state-item">
                    <div class="state-label">VS</div>
                    <div style="font-size: 16px; color: #818cf8;">⚔️</div>
                </div>
                <div class="state-item">
                    <div class="state-label">MOB</div>
                    <div class="mob-name" id="mobName">{{ $mob->name }}</div>
                    <div class="state-value" id="mobState">IDLE</div>
                    <!-- Enemy Finish Move Meter -->
                    <div class="finishMoveMeterSmall">
                        <div class="finishMoveBarSmall">
                            <div class="finishMoveBackgroundSmall"></div>
                            <div id="enemyFinishMoveFill" class="finishMoveFillSmall"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Game Container -->
            <div id="arena3-container">
                <!-- red container div -->
                <div id="topBar">
        <!-- smaller red container div -->
        <div id="smallBar">
            <!-- player health -->
            <div class="playerHContainer" >
                <div class="backgroundHealth"></div>
                <div id="playerHealth"></div>
            </div>
            <!-- round display -->
            <div id="roundDisplay">Round 1</div>
            <!-- enemy health -->
            <div class="healthContainer">
                <div class="backgroundHealth"></div>
                <div id="enemyHealth"></div>
            </div>
        </div>
        <div id="gameStatus">
            Tie
        </div>
                    <canvas></canvas>
                </div>
            </div>
            
                <!-- Fight Log (Arena 1 Style) -->
                <div class="quest-card mb-8 mt-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4 text-center">⚔️ Battle Log</h3>
                    <div id="fightLog" class="max-h-56 overflow-y-auto space-y-2 bg-shadow-ink/30 rounded-lg p-4">
                        <div class="text-desert-sand text-sm font-mono p-2 bg-shadow-ink/50 rounded border-l-4 border-ra-gold/50">Fight started!</div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js" integrity="sha512-H6cPm97FAsgIKmlBA4s774vqoN24V5gSQL4yBTDOY2su2DeXZVhQPxFK4P6GPdnZqM9fg1G3cMv5wD7e6cFLZQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    
    <!-- Pass character and mob data to JavaScript -->
    @if(!isset($showSelection) || !$showSelection)
    <script>
        window.ARENA3_DATA = {
            character: {
                slug: '{{ $character->slug }}',
                name: '{{ $character->name }}',
                sprites: @json($characterSprites ?? []),
                stats: @json($characterStats ?? [])
            },
            mob: {
                slug: '{{ $mob->slug }}',
                name: '{{ $mob->name }}',
                sprites: @json($mobSprites ?? []),
                stats: @json($mobStats ?? [])
            },
            basePath: '{{ url("/") }}/',
            backgroundPath: '{{ $backgroundPath ?? asset("arean 3/backgrounds/Background1.png") }}',
            shopPath: '{{ $shopPath ?? asset("arean 3/backgrounds/shop_anim.png") }}'
        };
    </script>
    @endif
    
    @if(!isset($showSelection) || !$showSelection)
    <script>
        // Function to update state display
        window.updateCharacterState = function(state) {
            const stateElement = document.getElementById('characterState');
            if (stateElement) {
                const stateMap = {
                    'idle': 'IDLE',
                    'run': 'RUN',
                    'jump': 'JUMP',
                    'fall': 'FALL',
                    'attack1': 'ATTACK',
                    'takeHit': 'HIT',
                    'death': 'DEAD'
                };
                stateElement.textContent = stateMap[state] || state.toUpperCase();
            }
        };
        
        window.updateMobState = function(state) {
            const stateElement = document.getElementById('mobState');
            if (stateElement) {
                const stateMap = {
                    'idle': 'IDLE',
                    'run': 'RUN',
                    'jump': 'JUMP',
                    'fall': 'FALL',
                    'attack1': 'ATTACK',
                    'takeHit': 'HIT',
                    'death': 'DEAD'
                };
                stateElement.textContent = stateMap[state] || state.toUpperCase();
            }
        };
        
        // Function to update round display
        window.updateRoundDisplay = function(roundNumber) {
            const roundElement = document.getElementById('roundDisplay');
            if (roundElement) {
                roundElement.textContent = `Round ${roundNumber}`;
            }
        };
        
        // Function to create slash effect
        window.createSlashEffect = function(attackerX, targetX, targetY, isCritical = false) {
            const container = document.getElementById('topBar');
            if (!container) return;
            
            // Get canvas element
            const canvas = document.querySelector('canvas');
            if (!canvas) return;
            
            // Get container and canvas dimensions
            const containerRect = container.getBoundingClientRect();
            const canvasRect = canvas.getBoundingClientRect();
            
            // Canvas dimensions (logical size)
            const canvasWidth = canvas.width;
            const canvasHeight = canvas.height;
            
            // Calculate center position between attacker and target (in canvas coordinates)
            const centerX = (attackerX + targetX) / 2;
            const centerY = targetY;
            
            // Convert canvas coordinates to container-relative pixels
            // Account for canvas scaling if it exists
            const scaleX = canvasRect.width / canvasWidth;
            const scaleY = canvasRect.height / canvasHeight;
            
            // Calculate pixel positions relative to container
            const containerX = canvasRect.left - containerRect.left;
            const containerY = canvasRect.top - containerRect.top;
            
            const pixelX = containerX + (centerX * scaleX);
            const pixelY = containerY + (centerY * scaleY);
            const targetPixelX = containerX + (targetX * scaleX);
            const targetPixelY = containerY + (targetY * scaleY);
            
            // Create slash effect
            const slash = document.createElement('div');
            slash.className = `slash-effect ${isCritical ? 'critical' : ''}`;
            slash.style.position = 'absolute';
            slash.style.left = `${pixelX}px`;
            slash.style.top = `${pixelY}px`;
            slash.style.transform = `translate(-50%, -50%) rotate(${attackerX < targetX ? -45 : 45}deg)`;
            
            container.appendChild(slash);
            
            // Create energy wave at impact point
            const wave = document.createElement('div');
            wave.className = 'energy-wave';
            wave.style.position = 'absolute';
            wave.style.left = `${targetPixelX}px`;
            wave.style.top = `${targetPixelY}px`;
            container.appendChild(wave);
            
            // Create impact sparks
            const sparksContainer = document.createElement('div');
            sparksContainer.className = 'impact-sparks';
            sparksContainer.style.position = 'absolute';
            sparksContainer.style.left = `${targetPixelX}px`;
            sparksContainer.style.top = `${targetPixelY}px`;
            
            // Generate multiple sparks
            for (let i = 0; i < 8; i++) {
                const spark = document.createElement('div');
                spark.className = 'spark';
                const angle = (Math.PI * 2 * i) / 8;
                const distance = 30 + Math.random() * 40;
                const sparkX = Math.cos(angle) * distance;
                const sparkY = Math.sin(angle) * distance;
                spark.style.setProperty('--spark-x', `${sparkX}px`);
                spark.style.setProperty('--spark-y', `${sparkY}px`);
                spark.style.left = '50%';
                spark.style.top = '50%';
                sparksContainer.appendChild(spark);
            }
            
            container.appendChild(sparksContainer);
            
            // Cleanup after animation
            setTimeout(() => {
                if (slash.parentNode) slash.parentNode.removeChild(slash);
                if (wave.parentNode) wave.parentNode.removeChild(wave);
                if (sparksContainer.parentNode) sparksContainer.parentNode.removeChild(sparksContainer);
            }, 800);
        };
        
        // Function to update game status (winner display)
        window.updateGameStatus = function(text) {
            const gameStatusElement = document.getElementById('gameStatus');
            if (gameStatusElement) {
                gameStatusElement.innerHTML = text;
            }
        };
        
        // Function to add entry to fight log (Arena 1 style)
        window.addFightLogEntry = function(message, type = 'normal') {
            const fightLog = document.getElementById('fightLog');
            if (!fightLog) return;
            
            const entry = document.createElement('div');
            entry.className = 'text-desert-sand text-sm font-mono p-2 bg-shadow-ink/50 rounded border-l-4';
            
            // Set border color based on type
            if (type === 'critical') {
                entry.classList.add('border-yellow-500');
                entry.classList.add('bg-yellow-500/20');
                entry.classList.add('text-yellow-300');
            } else if (type === 'finish-move') {
                entry.classList.add('border-red-500');
                entry.classList.add('bg-red-500/20');
                entry.classList.add('text-red-300');
            } else if (type === 'victory') {
                entry.classList.add('border-green-500');
                entry.classList.add('bg-green-500/20');
                entry.classList.add('text-green-300');
            } else if (type === 'hit') {
                entry.classList.add('border-red-400');
            } else if (type === 'attack') {
                entry.classList.add('border-blue-400');
            } else {
                entry.classList.add('border-ra-gold/50');
            }
            
            entry.textContent = message;
            
            fightLog.appendChild(entry);
            
            // Auto-scroll to bottom
            fightLog.scrollTop = fightLog.scrollHeight;
            
            // Keep only last 50 entries
            while (fightLog.children.length > 50) {
                fightLog.removeChild(fightLog.firstChild);
            }
        };
        
        // Function to update finish move meters
        window.updatePlayerFinishMoveMeter = function(percentage) {
            const fillElement = document.getElementById('playerFinishMoveFill');
            if (fillElement) {
                fillElement.style.width = percentage + '%';
                if (percentage >= 100) {
                    fillElement.classList.add('full');
                } else {
                    fillElement.classList.remove('full');
                }
            }
        };
        
        window.updateEnemyFinishMoveMeter = function(percentage) {
            const fillElement = document.getElementById('enemyFinishMoveFill');
            if (fillElement) {
                fillElement.style.width = percentage + '%';
                if (percentage >= 100) {
                    fillElement.classList.add('full');
                } else {
                    fillElement.classList.remove('full');
                }
            }
        };
    </script>
    
    <script src="{{ asset('arean 3/js/utils.js') }}"></script>
    <script src="{{ asset('arean 3/js/classes.js') }}"></script>
    <script src="{{ asset('arean 3/index.js') }}"></script>
    @endif
</x-app-layout>

