@php
    $characterSlug = request('character', '');
    $mobSlug = request('mob', '');
    if (empty($characterSlug) || empty($mobSlug)) {
        header('Location: ' . route('characters.test-fight'));
        exit;
    }
@endphp
<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">⚔️</span>
            </h2>
            <a href="{{ route('characters.test-fight') }}" class="cartouche-button text-sm">
                ← Back to Selection
            </a>
        </div>
    </x-slot>

    <style>
        .arena-background {
            background: 
                linear-gradient(180deg, #0a0a1a 0%, #1a1a2e 30%, #2d1b3d 60%, #1a1a2e 100%),
                radial-gradient(ellipse at center, rgba(139, 69, 19, 0.3) 0%, transparent 70%);
            position: relative;
            overflow: hidden;
            min-height: 100vh;
        }

        .arena-background::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                radial-gradient(ellipse 200px 400px at 10% 20%, rgba(139, 69, 19, 0.2) 0%, transparent 50%),
                radial-gradient(ellipse 200px 400px at 90% 20%, rgba(139, 69, 19, 0.2) 0%, transparent 50%),
                radial-gradient(circle at 15% 10%, rgba(255, 193, 7, 0.15) 0%, transparent 40%),
                radial-gradient(circle at 85% 10%, rgba(255, 193, 7, 0.15) 0%, transparent 40%),
                radial-gradient(circle at 50% 50%, rgba(139, 69, 19, 0.1) 0%, transparent 60%),
                linear-gradient(180deg, transparent 0%, rgba(0, 0, 0, 0.4) 100%);
            pointer-events: none;
            animation: arenaPulse 4s ease-in-out infinite;
        }

        @keyframes arenaPulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.9; }
        }

        .arena-background::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                repeating-linear-gradient(
                    45deg,
                    transparent,
                    transparent 100px,
                    rgba(255, 193, 7, 0.03) 100px,
                    rgba(255, 193, 7, 0.03) 102px
                ),
                repeating-linear-gradient(
                    -45deg,
                    transparent,
                    transparent 100px,
                    rgba(244, 67, 54, 0.03) 100px,
                    rgba(244, 67, 54, 0.03) 102px
                );
            pointer-events: none;
            animation: dustFloat 20s linear infinite;
        }

        @keyframes dustFloat {
            0% { transform: translateY(0) translateX(0); }
            100% { transform: translateY(-100px) translateX(50px); }
        }

        #arena2-container {
            position: relative;
            z-index: 10;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 200px);
            padding: 20px;
        }

        #arena2-container iframe,
        #arena2-container > div {
            border: 8px solid #d4af37;
            border-radius: 8px;
            box-shadow: 0 0 30px rgba(212, 175, 55, 0.5);
        }
    </style>

    @push('head')
        {!! $gameHead !!}
    @endpush

    <div class="py-12 min-h-screen arena-background relative">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 relative z-10">
            <div id="arena2-container" style="background: transparent;">
                {!! $gameBody !!}
            </div>
        </div>
    </div>
</x-app-layout>

