@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">👤</span>
            <span>Character Collection</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-6 p-4 bg-green-900/50 border-2 border-green-500 rounded-lg text-green-300">
                    <p class="font-egyptian">{{ session('success') }}</p>
                </div>
            @endif
            
            @if(session('error'))
                <div class="mb-6 p-4 bg-red-900/50 border-2 border-red-500 rounded-lg text-red-300">
                    <p class="font-egyptian">{{ session('error') }}</p>
                </div>
            @endif

            <!-- Currently Equipped Character -->
            @if($user->character)
            <div class="quest-card mb-6 border-ra-gold border-2">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Currently Equipped</h3>
                <div class="flex items-center gap-4">
                    <div class="w-24 h-24">
                        <x-character-animation 
                            :character="$user->character" 
                            state="idle" 
                            class="w-24 h-24 rounded-lg border-2 border-ra-gold"
                        />
                    </div>
                    <div class="flex-1">
                        <h4 class="font-egyptian text-lg text-ra-gold">{{ $user->character->name }}</h4>
                        <p class="text-desert-sand text-sm">{{ $user->character->description }}</p>
                        @if($user->character->hp_bonus || $user->character->attack_bonus || $user->character->defense_bonus)
                        <div class="flex gap-2 mt-2 text-xs">
                            @if($user->character->hp_bonus > 0)
                                <span class="text-nile-turquoise">+{{ $user->character->hp_bonus }} HP</span>
                            @endif
                            @if($user->character->attack_bonus > 0)
                                <span class="text-blood-red">+{{ $user->character->attack_bonus }} Attack</span>
                            @endif
                            @if($user->character->defense_bonus > 0)
                                <span class="text-nile-turquoise">+{{ $user->character->defense_bonus }} Defense</span>
                            @endif
                        </div>
                        @endif
                    </div>
                    <form method="POST" action="{{ route('characters.unequip') }}">
                        @csrf
                        <button type="submit" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Unequip
                        </button>
                    </form>
                </div>
            </div>
            @endif

            <!-- Owned Characters -->
            @if($ownedCharacters->count() > 0)
            <div class="quest-card mb-6">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Your Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($ownedCharacters as $character)
                    <div class="border-2 {{ $user->character_id === $character->id ? 'border-ra-gold bg-ra-gold/10' : 'border-ra-gold/30' }} rounded-lg p-4">
                        <div class="w-full h-48 mb-3">
                            <x-character-animation 
                                :character="$character" 
                                state="idle" 
                                class="w-full h-48 rounded-lg border border-ra-gold/30"
                            />
                        </div>
                        <h4 class="font-egyptian text-lg text-ra-gold mb-1">{{ $character->name }}</h4>
                        <p class="text-desert-sand text-xs mb-2">{{ Str::limit($character->description ?? '', 60) }}</p>
                        @if($character->hp_bonus || $character->attack_bonus || $character->defense_bonus)
                        <div class="flex flex-wrap gap-1 mb-3 text-xs">
                            @if($character->hp_bonus > 0)
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+{{ $character->hp_bonus }} HP</span>
                            @endif
                            @if($character->attack_bonus > 0)
                                <span class="px-2 py-1 bg-blood-red/20 text-blood-red rounded">+{{ $character->attack_bonus }} Attack</span>
                            @endif
                            @if($character->defense_bonus > 0)
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+{{ $character->defense_bonus }} Defense</span>
                            @endif
                        </div>
                        @endif
                        @if($user->character_id !== $character->id)
                        <form method="POST" action="{{ route('characters.equip', $character) }}">
                            @csrf
                            <button type="submit" class="w-full cartouche-button text-sm">
                                Equip
                            </button>
                        </form>
                        @else
                        <div class="w-full text-center py-2 text-ra-gold font-egyptian text-sm">
                            ✓ Equipped
                        </div>
                        @endif
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Shop Characters -->
            @if($shopCharacters->count() > 0)
            <div class="quest-card mb-6">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Available Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($shopCharacters as $character)
                    <div class="border-2 border-ra-gold/30 rounded-lg p-4">
                        <div class="w-full h-48 mb-3">
                            <x-character-animation 
                                :character="$character" 
                                state="idle" 
                                class="w-full h-48 rounded-lg border border-ra-gold/30"
                            />
                        </div>
                        <h4 class="font-egyptian text-lg text-ra-gold mb-1">{{ $character->name }}</h4>
                        <p class="text-desert-sand text-xs mb-2">{{ Str::limit($character->description ?? '', 60) }}</p>
                        @if($character->hp_bonus || $character->attack_bonus || $character->defense_bonus)
                        <div class="flex flex-wrap gap-1 mb-3 text-xs">
                            @if($character->hp_bonus > 0)
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+{{ $character->hp_bonus }} HP</span>
                            @endif
                            @if($character->attack_bonus > 0)
                                <span class="px-2 py-1 bg-blood-red/20 text-blood-red rounded">+{{ $character->attack_bonus }} Attack</span>
                            @endif
                            @if($character->defense_bonus > 0)
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+{{ $character->defense_bonus }} Defense</span>
                            @endif
                        </div>
                        @endif
                        <div class="mb-3">
                            @if($character->unlock_level)
                                <p class="text-desert-sand text-xs mb-1">Unlocks at Rank {{ $character->unlock_level }}</p>
                            @endif
                            @if($character->cost_gold)
                                <p class="text-ra-gold text-sm font-stat">💰 {{ number_format($character->cost_gold) }} Gold</p>
                            @endif
                            @if($character->cost_premium)
                                <p class="text-nile-turquoise text-sm font-stat">💎 {{ number_format($character->cost_premium) }} Premium Coins</p>
                            @endif
                            @if($character->is_vip_only)
                                <p class="text-yellow-400 text-xs">VIP Only</p>
                            @endif
                        </div>
                        @if($character->isPurchasable() && (!$character->is_vip_only || $user->isVip()))
                        <form method="POST" action="{{ route('characters.purchase', $character) }}">
                            @csrf
                            <button type="submit" class="w-full cartouche-button text-sm">
                                Purchase
                            </button>
                        </form>
                        @elseif($character->unlock_level && $user->level >= $character->unlock_level)
                        <div class="w-full text-center py-2 text-green-400 font-egyptian text-sm">
                            ✓ Unlocked (Equip from Your Characters)
                        </div>
                        @else
                        <div class="w-full text-center py-2 text-desert-sand/70 font-egyptian text-xs">
                            Locked
                        </div>
                        @endif
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Locked Characters -->
            @if($lockedCharacters->count() > 0)
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Locked Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($lockedCharacters as $character)
                    <div class="border-2 border-shadow-ink/30 rounded-lg p-4 opacity-60">
                        @if($character->image_normal)
                            <img src="{{ $character->image_normal }}" alt="{{ $character->name }}" 
                                 class="w-full h-48 object-cover rounded-lg mb-3 border border-shadow-ink/30 grayscale">
                        @else
                            <div class="w-full h-48 bg-gradient-to-br from-shadow-ink/20 to-papyrus-dark/20 border border-shadow-ink/30 rounded-lg mb-3 flex items-center justify-center">
                                <span class="text-6xl">🔒</span>
                            </div>
                        @endif
                        <h4 class="font-egyptian text-lg text-desert-sand/70 mb-1">{{ $character->name }}</h4>
                        <p class="text-desert-sand/50 text-xs mb-2">{{ Str::limit($character->description ?? '', 60) }}</p>
                        <div class="text-center">
                            <p class="text-desert-sand/70 text-xs">Requires Rank {{ $character->unlock_level }}</p>
                            <p class="text-desert-sand/50 text-xs mt-1">Your Rank: {{ $user->level }}</p>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-app-layout>

