<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">🎬</span>
                <span>Character Animation Test</span>
            </h2>
            <a href="{{ route('characters.index') }}" class="cartouche-button">
                Back to Characters
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                    Test all animation states for each character using PNG sequences.
                </p>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-2 text-sm">
                    <div class="bg-ra-gold/20 border border-ra-gold rounded p-2">
                        <span class="font-bold text-ra-gold">PNG Sequence</span> - Image sequences (01.png, 02.png, ...)
                    </div>
                    <div class="bg-green-600/20 border border-green-600 rounded p-2">
                        <span class="font-bold text-green-400">Available</span> - Animation exists
                    </div>
                    <div class="bg-blood-red/20 border border-blood-red rounded p-2">
                        <span class="font-bold text-blood-red">Missing</span> - No animation found
                    </div>
                </div>
            </div>

            @foreach($characters as $charData)
                @php
                    $character = $charData['character'];
                    $states = $charData['states'];
                    $pngStates = $states['png'] ?? [];
                    $allCharacterStates = $pngStates;
                    $initialState = !empty($allCharacterStates) ? $allCharacterStates[0] : 'idle';
                @endphp

                <div class="quest-card mb-6" 
                     data-character-slug="{{ $character->slug }}"
                     data-png-states='@json($pngStates)'
                     x-data="{
                         selectedState: '{{ $initialState }}',
                         characterSlug: $el.dataset.characterSlug,
                         pngStates: JSON.parse($el.dataset.pngStates || '[]'),
                         get hasPng() {
                             return this.pngStates.includes(this.selectedState);
                         },
                         changeState(newState) {
                             this.selectedState = newState;
                             window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                                 detail: {
                                     characterSlug: this.characterSlug,
                                     state: newState
                                 }
                             }));
                         }
                     }"
                     x-init="$watch('selectedState', (newState) => {
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: '{{ $character->slug }}',
                                 state: newState
                             }
                         }));
                     })">
                    <!-- Character Header -->
                    <div class="flex items-center justify-between mb-4 pb-4 border-b-2 border-ra-gold/30">
                        <div>
                            <h3 class="font-egyptian text-2xl text-ra-gold mb-1">{{ $character->name }}</h3>
                            <p class="text-desert-sand text-sm">{{ $character->description ?? 'No description' }}</p>
                        </div>
                        <div class="text-right">
                            <div class="text-sm text-desert-sand">
                                <span class="text-ra-gold">{{ count($pngStates) }}</span> PNG sequences
                            </div>
                        </div>
                    </div>

                    <!-- State Selector -->
                    <div class="mb-4">
                        <label class="block text-desert-sand font-semibold mb-2">Select Animation State:</label>
                        <div class="grid grid-cols-3 md:grid-cols-5 gap-2">
                            @foreach($allStates as $state)
                                @php
                                    $hasPng = in_array($state, $pngStates);
                                    $isAvailable = $hasPng;
                                @endphp
                                @php
                                    $buttonClass = $isAvailable 
                                        ? 'bg-papyrus-dark border border-ra-gold/30 hover:bg-papyrus-dark/80' 
                                        : 'bg-shadow-ink border border-blood-red/30 opacity-50';
                                @endphp
                                <button 
                                    @click="changeState('{{ $state }}')"
                                    :class="selectedState === '{{ $state }}' 
                                        ? 'bg-ra-gold text-shadow-ink border-2 border-ra-gold' 
                                        : '{{ $buttonClass }}'"
                                    class="px-3 py-2 rounded-lg text-sm font-semibold transition-all text-desert-sand"
                                    :disabled="{{ !$isAvailable ? 'true' : 'false' }}">
                                    <div class="flex items-center justify-center gap-1">
                                        @if($hasPng)
                                            <span class="text-ra-gold" title="Has PNG sequence">📸</span>
                                        @endif
                                        <span class="text-xs">{{ str_replace('_', ' ', $state) }}</span>
                                    </div>
                                </button>
                            @endforeach
                        </div>
                    </div>

                    <!-- Animation Display -->
                    <div class="bg-papyrus-dark/50 rounded-lg p-6 border-2 border-ra-gold/30">
                        <div class="text-center mb-4">
                            <div class="inline-flex items-center gap-2 px-4 py-2 bg-papyrus-dark rounded-lg">
                                <span class="text-desert-sand font-semibold">Current State:</span>
                                <span class="text-ra-gold font-egyptian text-lg" x-text="selectedState.replace('_', ' ')"></span>
                                <span x-show="hasPng" class="text-ra-gold" title="PNG sequence available">📸</span>
                            </div>
                        </div>

                        <!-- Animation Container -->
                        <div class="flex justify-center">
                            <div class="w-full max-w-md">
                                <x-character-animation 
                                    :character="$character" 
                                    :state="!empty($allCharacterStates) ? $allCharacterStates[0] : 'idle'"
                                    class="w-full rounded-lg border-4 border-ra-gold shadow-gold-glow"
                                    :autoplay="true"
                                    x-ref="characterAnimation"
                                />
                            </div>
                        </div>

                        <!-- State Info -->
                        <div class="mt-4">
                            <div class="bg-papyrus-dark/50 rounded p-3 border border-ra-gold/20">
                                <div class="font-semibold text-desert-sand mb-1">PNG Sequence:</div>
                                <div x-show="hasPng" class="text-ra-gold">
                                    <div>✓ Folder: <span x-text="'/assets/characters/' + characterSlug + '/' + (selectedState === 'attack' ? 'fight' : selectedState)"></span></div>
                                    <div class="text-xs mt-1">(01.png, 02.png, 03.png, ...)</div>
                                </div>
                                <div x-show="!hasPng" class="text-blood-red">
                                    ✗ No PNG sequence found
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- All States Summary -->
                    <div class="mt-4 p-4 bg-papyrus-dark/30 rounded-lg">
                        <h4 class="font-egyptian text-lg text-ra-gold mb-2">Available States Summary:</h4>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-xs">
                            @foreach($allStates as $state)
                                @php
                                    $hasPng = in_array($state, $pngStates);
                                @endphp
                                <div class="flex items-center gap-1 p-2 rounded {{ $hasPng ? 'bg-green-900/20 border border-green-600/30' : 'bg-red-900/20 border border-red-600/30' }}">
                                    @if($hasPng)
                                        <span class="text-ra-gold">📸</span>
                                    @endif
                                    <span class="text-desert-sand">{{ str_replace('_', ' ', $state) }}</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endforeach

            @if($characters->isEmpty())
                <div class="quest-card text-center">
                    <p class="text-desert-sand text-xl">No characters found.</p>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>

