<x-app-layout>
    @push('head')
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Press+Start+2P&display=swap" rel="stylesheet">
    @endpush
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="text-3xl text-ra-gold text-shadow-gold flex items-center gap-3" style="font-family: 'Press Start 2P', monospace !important;">
                <span class="text-4xl">⚔️</span>
                <span>Fight Animation </span>
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('characters.test-animations') }}" class="cartouche-button">
                    Character 
                </a>
                <a href="{{ route('characters.index') }}" class="cartouche-button">
                    Back to Characters
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                     fight animations with character (facing right) and mob (facing left) side by side.
                </p>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-sm">
                    <div class="bg-nile-turquoise/20 border border-nile-turquoise rounded p-2">
                        <span class="font-bold text-nile-turquoise">Character</span> - Facing right (→)
                    </div>
                    <div class="bg-blood-red/20 border border-blood-red rounded p-2">
                        <span class="font-bold text-blood-red">Mob</span> - Facing left (←)
                    </div>
                    <div class="bg-ra-gold/20 border border-ra-gold rounded p-2">
                        <span class="font-bold text-ra-gold">PNG Sequence</span> - Image sequences
                    </div>
                    <div class="bg-green-600/20 border border-green-600 rounded p-2">
                        <span class="font-bold text-green-400">Available</span> - Animation exists
                    </div>
                </div>
            </div>

            @php
                // Pre-encode character and mob data to avoid JSON parsing issues in x-data
                $charactersData = [];
                foreach ($characters as $char) {
                    $charactersData[$char->slug] = [
                        'slug' => $char->slug,
                        'name' => $char->name,
                        'states' => $char->getAllAnimationStates(),
                        'attack_power' => $char->attack ?? 50 // Default attack power
                    ];
                }
                $mobsData = [];
                foreach ($mobs as $mobItem) {
                    $mobsData[$mobItem->slug] = [
                        'slug' => $mobItem->slug,
                        'name' => $mobItem->name,
                        'states' => [
                            'png' => $mobItem->getPngSequenceStates('left')
                        ],
                        'attack_power' => $mobItem->attack ?? 40 // Default attack power
                    ];
                }
            @endphp

            <!-- Character and Mob Selection and Fight Arena -->
            <div 
                data-characters='@json($charactersData)'
                data-mobs='@json($mobsData)'
                x-data="{
                     selectedCharacterSlug: '',
                     selectedMobSlug: '',
                     selectedBackgroundId: {{ $selectedBackground ? $selectedBackground->id : 'null' }},
                     characterState: 'idle',
                     mobState: 'idle',
                     character: null,
                     mob: null,
                     characterStates: [],
                     mobStates: [],
                     charactersData: JSON.parse($el.dataset.characters || '{}'),
                     mobsData: JSON.parse($el.dataset.mobs || '{}'),
                     
                     updateCharacter() {
                         if (!this.selectedCharacterSlug) {
                             this.character = null;
                             this.characterStates = [];
                             return;
                         }
                         
                         // Get character data
                         if (this.charactersData[this.selectedCharacterSlug]) {
                             this.character = this.charactersData[this.selectedCharacterSlug];
                             this.characterStates = this.character.states.png || [];
                         } else {
                             this.character = null;
                             this.characterStates = [];
                             return;
                         }
                         
                         // Reset to idle
                         this.characterState = 'idle';
                         this.triggerCharacterAnimation('idle');
                     },
                     
                     updateMob() {
                         if (!this.selectedMobSlug) {
                             this.mob = null;
                             this.mobStates = [];
                             return;
                         }
                         
                         // Get mob data
                         if (this.mobsData[this.selectedMobSlug]) {
                             this.mob = this.mobsData[this.selectedMobSlug];
                             this.mobStates = this.mob.states.png || [];
                         } else {
                             this.mob = null;
                             this.mobStates = [];
                             return;
                         }
                         
                         // Reset to idle
                         this.mobState = 'idle';
                         this.triggerMobAnimation('idle');
                     },
                     
                     triggerCharacterAnimation(state) {
                         this.characterState = state;
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: this.selectedCharacterSlug,
                                 state: state
                             }
                         }));
                     },
                     
                     triggerMobAnimation(state) {
                         this.mobState = state;
                         window.dispatchEvent(new CustomEvent('mob-animation-state-change', {
                             detail: {
                                 mobSlug: this.selectedMobSlug,
                                 state: state
                             }
                         }));
                     },
                     
                     triggerBoth(state) {
                         this.triggerCharacterAnimation(state);
                         this.triggerMobAnimation(state);
                     },
                     
                     triggerCharacterWin() {
                         this.triggerCharacterAnimation('win');
                         this.triggerMobAnimation('lose');
                     },
                     
                     triggerMobWin() {
                         this.triggerCharacterAnimation('lose');
                         this.triggerMobAnimation('win');
                     }
                }">
                
                <!-- Character and Mob Selection -->
                <div class="quest-card mb-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4">Select Characters</h3>
                    @if($characters->isEmpty() || $mobs->isEmpty())
                        <div class="bg-papyrus-dark/50 border-2 border-ra-gold/30 rounded-lg p-6 text-center">
                            <p class="text-desert-sand mb-2">
                                @if($characters->isEmpty() && $mobs->isEmpty())
                                    <strong class="text-ra-gold">No characters or mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character and one mob.</span>
                                @elseif($characters->isEmpty())
                                    <strong class="text-nile-turquoise">No characters with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character.</span>
                                @else
                                    <strong class="text-blood-red">No mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one mob.</span>
                                @endif
                            </p>
                            <p class="text-desert-sand/70 text-xs mt-4">
                                Characters and mobs without animation folders are automatically excluded from this  page.
                            </p>
                        </div>
                    @else
                        <div class="grid grid-cols-2 gap-6 mb-6">
                            <!-- Character Selection -->
                            <div>
                                <label class="block text-desert-sand font-semibold mb-2">Character:</label>
                                <select 
                                    x-model="selectedCharacterSlug"
                                    @change="updateCharacter()"
                                    class="w-full bg-papyrus-dark border border-ra-gold/30 rounded-lg px-4 py-2 text-desert-sand">
                                    <option value="">Select Character...</option>
                                    @foreach($characters as $character)
                                        <option value="{{ $character->slug }}">{{ $character->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <!-- Mob Selection -->
                            <div>
                                <label class="block text-desert-sand font-semibold mb-2">Mob:</label>
                                <select 
                                    x-model="selectedMobSlug"
                                    @change="updateMob()"
                                    class="w-full bg-papyrus-dark border border-blood-red/30 rounded-lg px-4 py-2 text-desert-sand">
                                    <option value="">Select Mob...</option>
                                    @foreach($mobs as $mob)
                                        <option value="{{ $mob->slug }}">{{ $mob->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                        <!-- Background Selection (Arena 3 only) -->
                        <div class="mb-6">
                            <label class="block text-desert-sand font-semibold mb-2">Arena 3 Background:</label>
                            <select 
                                x-model="selectedBackgroundId"
                                class="w-full bg-papyrus-dark border border-nile-turquoise/30 rounded-lg px-4 py-2 text-desert-sand">
                                <option value="">Select Background...</option>
                                @foreach($allBackgrounds as $bg)
                                    @if(in_array($bg->id, $ownedBackgroundIds))
                                        <option value="{{ $bg->id }}" {{ $selectedBackground && $selectedBackground->id == $bg->id ? 'selected' : '' }}>
                                            {{ $bg->name }} ✓
                                        </option>
                                    @else
                                        <option value="{{ $bg->id }}" disabled>
                                            {{ $bg->name }} 🔒 (Locked)
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                            <p class="text-sm text-desert-sand/70 mt-1">Select a background for Arena 3. Locked backgrounds are not available.</p>
                        </div>
                    @endif
                </div>

                <!-- Enter Arena Buttons -->
                <div class="text-center mb-6" x-show="selectedCharacterSlug && selectedMobSlug">
                    <div class="flex gap-4 justify-center flex-wrap">
                        <a 
                            :href="'/characters/arena-3?character=' + selectedCharacterSlug + '&mob=' + selectedMobSlug + (selectedBackgroundId && selectedBackgroundId !== null ? '&background=' + selectedBackgroundId : '')"
                            class="inline-block px-8 py-3 bg-blood-red text-shadow-ink font-egyptian text-lg rounded-lg hover:bg-blood-red/80 transition-all border-2 border-blood-red/50 shadow-lg">
                            ⚔️ Enter Arena  ⚔️
                        </a>
                    </div>
                </div>

                <!-- Fight Arena -->
                @if(!$characters->isEmpty() && !$mobs->isEmpty())
                <div class="quest-card">
                
                <!-- Animation Display -->
                <div class="grid grid-cols-2 gap-8 mb-6">
                    <!-- Character Side (Right Facing) -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3" x-text="character ? character.name : 'No Character Selected'"></h3>
                        <div class="w-full max-w-md mx-auto">
                            @foreach($characters as $char)
                                <div x-show="selectedCharacterSlug === '{{ $char->slug }}'" style="display: none;">
                                    <x-character-animation 
                                        :character="$char"
                                        state="idle"
                                        direction="right"
                                        class="w-full rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow"
                                        :autoplay="true"
                                    />
                                </div>
                            @endforeach
                            <div x-show="!selectedCharacterSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-nile-turquoise/30">
                                <span class="text-desert-sand/50">Select a character</span>
                            </div>
                        </div>
                        
                        <!-- Character State Controls -->
                        <div class="mt-4" x-show="character">
                            <label class="block text-desert-sand font-semibold mb-2 text-sm">Character State:</label>
                            <div class="flex flex-wrap gap-2 justify-center">
                                @foreach($allStates as $state)
                                    <button 
                                        @click="triggerCharacterAnimation('{{ $state }}')"
                                        :class="characterState === '{{ $state }}' 
                                            ? 'bg-nile-turquoise text-shadow-ink border-2 border-nile-turquoise' 
                                            : 'bg-papyrus-dark border border-nile-turquoise/30 hover:bg-papyrus-dark/80'"
                                        class="px-3 py-1 rounded-lg text-xs font-semibold transition-all text-desert-sand">
                                        {{ str_replace('_', ' ', $state) }}
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    
                    <!-- Mob Side (Left Facing) -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-blood-red mb-3" x-text="mob ? mob.name : 'No Mob Selected'"></h3>
                        <div class="w-full max-w-md mx-auto">
                            @foreach($mobs as $mobItem)
                                <div x-show="selectedMobSlug === '{{ $mobItem->slug }}'" style="display: none;">
                                    <x-mob-animation 
                                        :mob="$mobItem"
                                        state="idle"
                                        direction="left"
                                        class="w-full rounded-lg border-4 border-blood-red shadow-gold-glow"
                                        :autoplay="true"
                                    />
                                </div>
                            @endforeach
                            <div x-show="!selectedMobSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-blood-red/30">
                                <span class="text-desert-sand/50">Select a mob</span>
                            </div>
                        </div>
                        
                        <!-- Mob State Controls -->
                        <div class="mt-4" x-show="mob">
                            <label class="block text-desert-sand font-semibold mb-2 text-sm">Mob State:</label>
                            <div class="flex flex-wrap gap-2 justify-center">
                                @foreach($allStates as $state)
                                    <button 
                                        @click="triggerMobAnimation('{{ $state }}')"
                                        :class="mobState === '{{ $state }}' 
                                            ? 'bg-blood-red text-shadow-ink border-2 border-blood-red' 
                                            : 'bg-papyrus-dark border border-blood-red/30 hover:bg-papyrus-dark/80'"
                                        class="px-3 py-1 rounded-lg text-xs font-semibold transition-all text-desert-sand">
                                        {{ str_replace('_', ' ', $state) }}
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Synchronized Actions -->
                <div class="mt-6 p-4 bg-papyrus-dark/30 rounded-lg border-2 border-ra-gold/30">
                    <h4 class="font-egyptian text-lg text-ra-gold mb-3 text-center">Synchronized Actions</h4>
                    <div class="flex flex-wrap gap-2 justify-center">
                        <button 
                            @click="triggerBoth('idle')"
                            class="px-4 py-2 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise rounded-lg text-desert-sand font-semibold transition-all">
                            Both Idle
                        </button>
                        <button 
                            @click="triggerBoth('attack')"
                            class="px-4 py-2 bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red rounded-lg text-desert-sand font-semibold transition-all">
                            Both Attack
                        </button>
                        <button 
                            @click="triggerBoth('magic')"
                            class="px-4 py-2 bg-purple-600/20 hover:bg-purple-600/30 border border-purple-600 rounded-lg text-desert-sand font-semibold transition-all">
                            Both Magic
                        </button>
                        <button 
                            @click="triggerCharacterWin()"
                            class="px-4 py-2 bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold rounded-lg text-desert-sand font-semibold transition-all">
                            Character Wins
                        </button>
                        <button 
                            @click="triggerMobWin()"
                            class="px-4 py-2 bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red rounded-lg text-desert-sand font-semibold transition-all">
                            Mob Wins
                        </button>
                    </div>
                </div>
                
                <!-- Folder Structure Info -->
                <div class="mt-6 p-4 bg-papyrus-dark/30 rounded-lg border-2 border-ra-gold/30">
                    <h4 class="font-egyptian text-lg text-ra-gold mb-3">Expected Folder Structure</h4>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <div class="font-semibold text-nile-turquoise mb-2">Character (Right Facing):</div>
                            <div class="text-desert-sand font-mono text-xs bg-shadow-ink p-2 rounded">
                                /assets/characters/{slug}/<br>
                                ├── idle/right/01.png, 02.png...<br>
                                ├── fight/right/01.png, 02.png...<br>
                                └── (or without /right/ for base)
                            </div>
                        </div>
                        <div>
                            <div class="font-semibold text-blood-red mb-2">Mob (Left Facing):</div>
                            <div class="text-desert-sand font-mono text-xs bg-shadow-ink p-2 rounded">
                                /assets/mobs/{slug}/<br>
                                ├── idle/left/01.png, 02.png...<br>
                                ├── attack/left/01.png, 02.png...<br>
                                └── (or without /left/ for base)
                            </div>
                        </div>
                    </div>
                </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>

