<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">💎</span>
                <span>Premium Coins</span>
            </h2>
            <div class="flex items-center gap-4">
                <div class="bg-nile-turquoise/20 border-2 border-nile-turquoise px-4 py-2 rounded-lg">
                    <span class="font-stat text-nile-turquoise text-xl">💎 {{ number_format($user->premium_coins) }} Coins</span>
                </div>
                <a href="{{ route('dashboard') }}" class="cartouche-button flex items-center gap-2">
                    <span>🏺</span>
                    <span>Dashboard</span>
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('error'))
                <div class="quest-card bg-gradient-to-r from-blood-red/20 to-red-900/20 border-blood-red mb-4">
                    <span class="block text-desert-sand">{{ session('error') }}</span>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($coinPacks as $pack)
                <div class="quest-card border-2 border-nile-turquoise/30 hover:scale-105 transition-all duration-300">
                    <div class="text-center mb-6">
                        <div class="text-5xl mb-2">💎</div>
                        <h3 class="font-egyptian text-2xl text-nile-turquoise text-shadow-turquoise mb-2">{{ $pack->name }}</h3>
                    </div>

                    <div class="space-y-4 mb-6">
                        <div class="p-3 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg text-center">
                            <div class="text-sm text-desert-sand mb-1">Total Coins</div>
                            <div class="font-stat text-3xl text-nile-turquoise">
                                {{ number_format($pack->total_coins) }}
                            </div>
                            @if($pack->bonus_coins > 0)
                            <div class="text-xs text-ra-gold mt-1">
                                +{{ number_format($pack->bonus_coins) }} bonus!
                            </div>
                            @endif
                        </div>

                        <div class="p-3 bg-ra-gold/10 border border-ra-gold rounded-lg">
                            <div class="text-sm text-desert-sand mb-1">Price</div>
                            <div class="font-stat text-2xl text-ra-gold">
                                ${{ number_format($pack->price_usd, 2) }}
                            </div>
                        </div>

                        <div class="text-xs text-desert-sand space-y-1">
                            <div class="flex justify-between">
                                <span>Base Coins:</span>
                                <span class="text-nile-turquoise">{{ number_format($pack->coins_amount) }}</span>
                            </div>
                            @if($pack->bonus_coins > 0)
                            <div class="flex justify-between">
                                <span>Bonus Coins:</span>
                                <span class="text-ra-gold">+{{ number_format($pack->bonus_coins) }}</span>
                            </div>
                            @endif
                        </div>
                    </div>

                    <form method="POST" action="{{ route('coins.buy') }}">
                        @csrf
                        <input type="hidden" name="pack_id" value="{{ $pack->id }}">
                        <button type="submit" class="w-full cartouche-button hover:scale-105 transition-transform duration-300">
                            Buy with PayPal
                        </button>
                    </form>
                </div>
                @empty
                <div class="col-span-full quest-card text-center py-12">
                    <div class="text-6xl mb-4">🏺</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No coin packs available at this time.</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>






