@props(['task'])

<div class="quest-card" x-data="{ completed: false }" x-on:quest-completed.window="completed = true">
    <div class="relative z-10">
        <div class="flex justify-between items-start mb-2">
            <h3 class="font-egyptian text-xl text-ra-gold text-shadow-gold">{{ $task->title }}</h3>
            <span class="px-2 py-1 text-xs rounded border 
                {{ $task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : '' }}
                {{ $task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : '' }}
                {{ $task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : '' }}">
                {{ ucfirst($task->status) }}
            </span>
        </div>
        
        @if($task->description)
        <p class="text-desert-sand text-sm mb-4">{{ Str::limit($task->description, 100) }}</p>
        @endif
        
        <div class="flex justify-between items-center text-sm mb-4">
            <div class="flex items-center gap-2">
                <span class="text-nile-turquoise">📜</span>
                <span class="text-desert-sand">{{ $task->category->name }}</span>
            </div>
            <div class="flex gap-3 flex-wrap">
                <span class="text-nile-turquoise font-stat">✨ {{ $task->points }} XP</span>
                @if($task->coins > 0)
                <span class="text-ra-gold font-stat">💰 {{ $task->coins }}</span>
                @endif
                @if($task->difficulty_level)
                <span class="text-desert-sand/70 text-xs capitalize">⚔️ {{ $task->difficulty_level }}</span>
                @endif
            </div>
        </div>

        @if($task->due_date)
        <div class="text-xs text-desert-sand/70 mb-4">
            ⏳ Due: {{ $task->due_date->format('M d, Y') }}
        </div>
        @endif

        <div class="flex gap-2">
            <a href="{{ route('tasks.show', $task) }}" class="flex-1 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                View Scroll
            </a>
            @if($task->status !== 'completed')
            <form method="POST" action="{{ route('tasks.complete', $task) }}" class="flex-1" 
                  x-on:submit="setTimeout(() => { $dispatch('quest-completed') }, 100)">
                @csrf
                <button type="submit" class="w-full bg-ra-gold hover:bg-ra-gold/80 text-papyrus-dark py-2 px-4 rounded-lg text-sm font-bold transition-all duration-300 shadow-gold-glow hover:shadow-gold-glow-lg">
                    Complete Quest
                </button>
            </form>
            @endif
        </div>
    </div>
    
    <!-- Completion Glow Animation -->
    <div x-show="completed" 
         x-transition:enter="transition ease-out duration-1000"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-500"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="absolute inset-0 bg-gradient-to-t from-ra-gold/30 to-transparent pointer-events-none">
    </div>
</div>

