@props(['scroll', 'viewMode' => 'cards', 'isExpanded' => true])

@php
    // Use category properties for scroll display
    $scrollColor = $scroll->color ?? '#d4a65a';
    $scrollIcon = $scroll->icon ?? '📜';
    $scrollTitle = $scroll->name ?? $scroll->title ?? 'Unnamed Scroll';
    $scrollDescription = $scroll->description ?? null;
@endphp

<div class="scroll-category mb-6" x-data="{ expanded: {{ $isExpanded ? 'true' : 'false' }} }">
    <!-- Scroll Header - Papyrus Style -->
    <div class="scroll-header bg-[#fdf2d2] border-2 rounded-xl shadow-md p-4 cursor-pointer hover:shadow-lg transition-all duration-300"
         style="border-color: {{ $scrollColor }};"
         @click="expanded = !expanded">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <div class="text-4xl">{{ $scrollIcon }}</div>
                <div>
                    <h3 class="font-egyptian text-2xl text-ra-gold font-bold" style="color: {{ $scrollColor }};">
                        {{ $scrollTitle }}
                    </h3>
                    @if($scrollDescription)
                        <p class="text-desert-sand/70 text-sm mt-1">{{ $scrollDescription }}</p>
                    @endif
                </div>
            </div>
            <div class="flex items-center gap-4">
                @if(isset($scroll->tasks) && $scroll->tasks->count() > 0)
                    <span class="px-3 py-1 rounded-full bg-papyrus-dark/50 text-desert-sand text-sm font-semibold border" style="border-color: {{ $scrollColor }};">
                        {{ $scroll->tasks->count() }} {{ Str::plural('Quest', $scroll->tasks->count()) }}
                    </span>
                @endif
                @if(isset($scroll->completed_count) && $scroll->completed_count > 0)
                    <a href="{{ route('tasks.completed', ['scroll' => $scroll->id]) }}" class="px-3 py-1 rounded-full bg-green-900/30 text-green-300 text-sm font-semibold border border-green-500 hover:bg-green-900/50 transition-colors">
                        ✅ {{ $scroll->completed_count }} Completed
                    </a>
                @endif
                <button class="text-2xl transition-transform duration-300" :class="{ 'rotate-180': expanded }">
                    ▼
                </button>
            </div>
        </div>
    </div>

    <!-- Scroll Content -->
    <div x-show="expanded" 
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform -translate-y-4"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="scroll-content mt-4">
        <div class="bg-papyrus-dark/30 rounded-lg p-6 border-2" style="border-color: {{ $scrollColor }};">
            @if(isset($scroll->tasks) && $scroll->tasks->count() > 0)
                @switch($viewMode)
                    @case('cards')
                        <x-quests.views.cards :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                        @break
                    @case('table')
                        <x-quests.views.table :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                        @break
                    @case('list')
                        <x-quests.views.list :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                        @break
                    @case('compact')
                        <x-quests.views.compact :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                        @break
                    @case('kanban')
                        <x-quests.views.kanban :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                        @break
                    @default
                        <x-quests.views.cards :tasks="$scroll->tasks" :scrollColor="$scrollColor" />
                @endswitch
            @else
                <div class="text-center py-12">
                    <div class="text-6xl mb-4 opacity-50">📜</div>
                    <p class="text-desert-sand/70 font-egyptian">No quests in this scroll yet.</p>
                    <a href="{{ route('tasks.create') }}" class="inline-block mt-4 cartouche-button">
                        Create Your First Quest
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

