@props(['currentView' => 'cards'])

@php
    $viewModes = [
        'cards' => ['icon' => '🃏', 'label' => 'Cards'],
        'table' => ['icon' => '📊', 'label' => 'Table'],
        'list' => ['icon' => '📋', 'label' => 'List'],
        'compact' => ['icon' => '📝', 'label' => 'Compact'],
        'kanban' => ['icon' => '📌', 'label' => 'Kanban'],
    ];
@endphp

<div class="view-switcher bg-papyrus-dark/50 rounded-lg p-3 border border-ra-gold/30 mb-6">
    <div class="flex items-center justify-between flex-wrap gap-3">
        <div class="flex items-center gap-2">
            <span class="text-desert-sand font-egyptian font-semibold">View Mode:</span>
        </div>
        <div class="flex gap-2 flex-wrap">
            @foreach($viewModes as $mode => $config)
                <button type="button" 
                        onclick="setViewMode('{{ $mode }}')"
                        class="view-mode-btn px-4 py-2 rounded-lg border-2 text-sm font-semibold transition-all duration-300
                            {{ $currentView === $mode 
                                ? 'bg-ra-gold border-ra-gold text-papyrus-dark shadow-gold-glow' 
                                : 'bg-papyrus-dark border-ra-gold/30 text-desert-sand hover:border-ra-gold hover:bg-papyrus-dark/70' }}">
                    <span class="mr-2">{{ $config['icon'] }}</span>
                    {{ $config['label'] }}
                </button>
            @endforeach
        </div>
    </div>
</div>

<script>
    function setViewMode(mode) {
        // Store in localStorage
        localStorage.setItem('quest_view_mode', mode);
        
        // Update URL parameter
        const url = new URL(window.location);
        url.searchParams.set('view', mode);
        window.location.href = url.toString();
    }
    
    // Load saved view mode on page load
    document.addEventListener('DOMContentLoaded', function() {
        const savedMode = localStorage.getItem('quest_view_mode');
        const urlParams = new URLSearchParams(window.location.search);
        const urlMode = urlParams.get('view');
        
        if (urlMode && urlMode !== '{{ $currentView }}') {
            // View mode from URL takes precedence
            setViewMode(urlMode);
        } else if (savedMode && savedMode !== '{{ $currentView }}') {
            // Apply saved mode if no URL parameter
            setViewMode(savedMode);
        }
    });
</script>

