@props(['tasks', 'scrollColor' => '#d4a65a'])

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
    @foreach($tasks as $task)
        <div class="quest-card-papyrus bg-[#fdf2d2] border-2 rounded-lg p-4 hover:shadow-lg transition-all duration-300"
             style="border-color: {{ $scrollColor }};">
            <div class="flex justify-between items-start mb-3">
                <h4 class="font-egyptian text-lg text-ra-gold font-bold flex-1">{{ $task->title }}</h4>
                <span class="px-2 py-1 text-xs rounded border capitalize
                    {{ $task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : '' }}
                    {{ $task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : '' }}
                    {{ $task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : '' }}">
                    {{ $task->status }}
                </span>
            </div>

            @if($task->description)
                <p class="text-desert-sand/70 text-sm mb-3 line-clamp-2">{{ Str::limit($task->description, 100) }}</p>
            @endif

            <div class="flex items-center gap-4 mb-3 text-sm">
                <div class="flex items-center gap-1">
                    <span class="text-nile-turquoise">✨</span>
                    <span class="text-desert-sand font-semibold">{{ $task->points }} XP</span>
                </div>
                @if($task->coins > 0)
                <div class="flex items-center gap-1">
                    <span class="text-ra-gold">💰</span>
                    <span class="text-desert-sand font-semibold">{{ $task->coins }}</span>
                </div>
                @endif
                @if($task->difficulty_level)
                <div class="flex items-center gap-1">
                    <span class="text-desert-sand/70 capitalize text-xs">⚔️ {{ $task->difficulty_level }}</span>
                </div>
                @endif
            </div>

            @if($task->category)
                <div class="mb-3">
                    <span class="px-2 py-1 text-xs rounded bg-papyrus-dark/50 text-desert-sand border border-ra-gold/30">
                        {{ $task->category->name }}
                    </span>
                </div>
            @endif

            <div class="flex gap-2">
                <a href="{{ route('tasks.show', $task) }}" 
                   class="flex-1 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                    View
                </a>
                @if($task->status !== 'completed')
                <form method="POST" action="{{ route('tasks.complete', $task) }}" class="flex-1">
                    @csrf
                    <button type="submit" class="w-full bg-ra-gold hover:bg-ra-gold/80 text-papyrus-dark py-2 px-4 rounded-lg text-sm font-bold transition-all duration-300 shadow-gold-glow">
                        Complete
                    </button>
                </form>
                @endif
            </div>
        </div>
    @endforeach
</div>

